package com.rocogz.syy.equity.dto.equity.coupon;

import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 创建产品使用规则 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-03-11 20:18:53</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class CouponInfoDto {

    /**
     * 是否编辑：true：新增，false：编辑
     */
    private boolean saveFlag;

    /**
     * 平台产品编号
     */
    private String productCode;

    /**
     * 平台产品名称
     */
    @NotNull(message = "产品名称" + EquityConstants.EMPTY_MESSAGE)
    private String productName;

    /**
     * 产品类别
     */
    @NotNull(message = "产品类别" + EquityConstants.EMPTY_MESSAGE)
    private String typeCode;

    /**
     * 描述信息
     */
    private String description;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 金额使用限制(最小金额）
     */
    @NotNull(message = "最小金额" + EquityConstants.EMPTY_MESSAGE)
    private BigDecimal amountUseLimit;

    /**
     * 金额使用限制(最大金额)
     */
    @NotNull(message = "最大金额" + EquityConstants.EMPTY_MESSAGE)
    private BigDecimal amountUseLimitMax;

    /**
     * 平台产品市场价
     */
    @NotNull(message = "平台产品市场价" + EquityConstants.EMPTY_MESSAGE)
    private BigDecimal faceValue;

    /**
     * 商户服务项目编号
     */
    private String serviceProjectCode;

    /**
     * 商户服务项目名称
     */
    private String serviceProjectName;

    /**
     * 门店编号
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

}
