package com.rocogz.syy.equity.dto.equity.recall;


import com.rocogz.syy.common.response.Response;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <dl>
 * <dd>Description:变更为处理中请求 </dd>
 * <dd>@date: 2021/08/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class RecallApplyInProcessReq {

    /**
     * 审核最后的结果状态
     */
    @NotBlank(message = "请传递撤回单号")
    private String recallCode;

    @NotBlank(message = "请传递撤回清单编号")
    private String applyDetailCode;

    /**
     * 操作人
     */
    @NotBlank(message = "请传操作人")
    private String operator;

    /**
     * 操作人手机号
     */
    private String operatorMobile;

    /**
     * 触发的操作:批量撤回，再次撤回，开始撤回
     */
    private String action;

}
