package com.rocogz.syy.equity.dto.equity.recall;

import com.rocogz.syy.equity.pager.Sort;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description:撤回的分页请求 </dd>
 * <dd>@date: 2021/08/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
public class RecallApplySearchReq {
    /**
     * 代理商编号，多选
     */
    private String agentCode;
    /**
     * 申请单状态
     */
    private String status;

    /**
     * 退款状态
     */
    private String quotaCoverRefundStatus;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 客户编号
     */
    private String customerCode;
    /**
     * 操作人(如果数据权限 勾选了 个人)
     */
    private String operateUser;

    /**
     * 平台ID
     */
    private String miniAppid;

    /**
     * 撤回申请单号
     */
    private String recallCode;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 客户手机号
     */
    private String mobile;

    /**
     * 发放人手机号 查询 ？？
     */
    private String grantApplyUserMobile;

    /**
     * 发放人手机号 查询到的 所属用户
     */
    private List<String> grantApplyUserList;


    /**
     * 发券性质：NORMAL-正常发券，BUSINESS_VERIFY：业务验证
     */
    private String nature;

    /**
     * 领取状态：Y-已领取，N-未领取
     */
    private String receiveStatus;

    /**
     * 撤回申请创建开始时间
     */
    private String recallCreateTimeStart;

    /**
     * 撤回申请创建结束时间
     */
    private String recallCreateTimeEnd;

    /**
     * 发放时间开始
     */
    private String grantTimeStart;

    /**
     * 发放时间结束
     */
    private String grantTimeEnd;

    /**
     * 撤回成功开始时间
     */
    private String recallSuccessTimeStart;

    /**
     * 撤回成功结束时间
     */
    private String recallSuccessTimeEnd;

    /**
     * 排序策略
     */
    private SortStrategyEnum sortStrategy;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 排序
     */
    private Sort sort;

    /**
     * 分页
     */
    private Integer limit = 20;
    /**
     * 当前第几页
     */
    private Integer page = 1;

    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;


    /**
     * 商品类型
     */
    public  enum SortStrategyEnum {

        RECALL_SUCCESS_TIME("recall_success_time", "desc");
        // 成员变量
        private String field;
        private String direction;
        // 构造方法
        private SortStrategyEnum(String field, String direction) {
            this.field = field;
            this.direction = direction;
        }

        public String getField() {
            return field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getDirection() {
            return direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }
    }




}
