package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 用户券消耗(滴滴打车券过期转使用) dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023-04-25 14:35:58</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserCouponConsumeParamDto {

    /**
     * 使用平台：默认传入SYY
     */
    @NotNull(message = "使用平台" + EquityConstants.EMPTY_MESSAGE)
    private String platformCode;

    /**
     * 使用方式：MANUAL-手工(com.rocogz.syy.equity.EquityConstants#USER_COUPON_GRANT_MODEL_MANUAL)，
     *         SYSTEM-系统（默认传入）(com.rocogz.syy.equity.EquityConstants#USER_COUPON_USE_WAY_SYSTEM)
     */
    @NotNull(message = "使用方式" + EquityConstants.EMPTY_MESSAGE)
    private String useWay;

    /**
     * 用户券编号列表
     */
    private List<String> userCouponCodeList;
}
