package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 批量发券审核规则配置操作记录表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-01-23 17:50:04</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_apply_limit_config_log")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionApplyLimitConfigLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 规则配置编号
     */
    private String code;

    /**
     * 操作结果
     */
    private String operateResult;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;


}
