package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 批量发券申请单操作日志 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:15</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_apply_operate_log")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionApplyOperateLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 操作状态，PASS-申请通过，CANCEL-作废， DISAGREE-申请不通过，AGAIN-再次处理
     */
    private String operateStatus;

    /**
     * 操作结果，SUCESS-成功，FAIL-失败，SOME_FAIL-部分失败，CANCEL-作废，DISAGREE-申请不通过
     */
    private String operateResult;

    /**
     * 总行数
     */
    private Integer totalRow;

    /**
     * 成功条数
     */
    private Integer successRow;

    /**
     * 失败条数
     */
    private Integer failRow;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

}
