package com.rocogz.syy.equity.dto.dataCorrect;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 主体修正客户产品参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-03-03 17:57:27</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class IssuingCustomerProductParamDto {

    /**
     * 主体编号
     */
    private String issuingCode;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 调整前客户产品编号
     */
    private String oldCustomerProductCode;

    /**
     * 调整前客户产品名称
     */
    private String oldCustomerProductName;

    /**
     * 调整前采购结算价
     */
    private BigDecimal oldPurchaseSettlePrice;

    /**
     * 调整前服务商产品编号
     */
    private String oldAgentProductCode;

    /**
     * 调整前服务商产品名称
     */
    private String oldAgentProductName;

    /**
     * 调整前平台产品编号
     */
    private String oldPlatformProductCode;

    /**
     * 调整前平台产品名称
     */
    private String oldPlatformProductName;

    /**
     * 调整后客户编号
     */
    private String newCustomerCode;

    /**
     * 调整后客户产品编号
     */
    private String newCustomerProductCode;

    /**
     * 调整后客户产品名称
     */
    private String newCustomerProductName;

    /**
     * 调整后采购结算价
     */
    private BigDecimal newPurchaseSettlePrice;

    /**
     * 调整后服务商产品编号
     */
    private String newAgentProductCode;

    /**
     * 调整后服务商产品名称
     */
    private String newAgentProductName;

    /**
     * 调整后平台产品编号
     */
    private String newPlatformProductCode;

    /**
     * 调整后平台产品名称
     */
    private String newPlatformProductName;
}
