package com.rocogz.syy.equity.entity.oilCardUserCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 大诚电子加油券-油卡请求操作流水 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-30 14:23:59</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_user_coupon_request_operate_serial")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardUserCouponRequestOperateSerial extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 油卡订单编号
     */
    private String oilOrderCode;

    /**
     * 操作状态（ADD-发放、CANCEL-作废、BACK-退回）
     */
    private String operateType;

    /**
     * 结果状态（INIT-初始，SUCCESS-操作成功，PROCESS-已通知，FAIL-通知失败，ABNORMAL-通知异常）
     */
    private String resultStatus;

    /**
     * 重试次数
     */
    private Integer retryQuantity;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
