package com.rocogz.syy.equity.dto.dataCorrect;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 主体修正客户参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-03-03 17:57:27</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class IssuingCustomerAndProductParamDto {

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 主体编号
     */
    private String issuingCode;

    /**
     * 调整前客户编号
     */
    private String oldCustomerCode;

    /**
     * 调整后客户编号
     */
    private String newCustomerCode;

    /**
     * 调整后客户简称
     */
    private String newCustomerAbbreviation;

    /**
     * 主体客户产品
     */
    private List<IssuingCustomerProductParamDto> productList;
}
