package com.rocogz.syy.equity.dto.equity.batchDistributionApply;

import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.template.EquityIssuingTemplateColumnDict;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <dl>
 * <dd>Description: 查询结算清单查询参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2023-07-14 15:22:14</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class BatchSettleDetailParamDto {

    /**
     * 产品所属供应商
     */
    @NotBlank
    private String productBelongSupplierCode;

    /**
     * 产品所属合作客户（机构）
     */
    @NotBlank
    private String productBelongCustomerCode;

    /**
     * 领取开始日期
     */
    private String receiveStartDate;

    /**
     * 领取结束日期
     */
    private String receiveEndDate;

    /**
     * 清单状态：
     * @see EquityConstants#BATCH_DISTRIBUTION_COMMON_STATUS_SUCCESS 已发放
     * @see EquityConstants#COMMON_FLAG_RECALL 已撤回
     */
    @NotBlank
    private String status;

    /**
     * 结算状态:
     * @see com.rocogz.syy.equity.EquityConstants.DictBatchDistributionDetailSettleStatus
     */
    @NotBlank
    private String settleStatus;

    /**
     * 领取状态:Y-已领取，N-未领取，查询对冲数据此字段不传
     */
    private String receiveStatus;

}
