package com.rocogz.syy.equity.dto.equity.batchDistributionApply;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 主体发券扣减额度清单记录 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-11-01 16:43:35</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class IssuingBodyDedutionAmountDetailParamDto {

    /**
     * 扣减额度主体编号
     */
    private String dedutionSourceCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 清单编号
     */
    private String code;

    /**
     * 申请人手机号
     */
    private String createUserMobile;

    /**
     * 权益编号
     */
    private String customerProductCode;

    /**
     * 权益名称
     */
    private String customerProductName;

    /**
     * 申请开始日期
     */
    private String createStartDate;

    /**
     * 申请结束日期
     */
    private String createEndDate;

    /**
     * 扣减开始日期
     */
    private String dedutionStartDate;

    /**
     * 扣减结束日期
     */
    private String dedutionEndDate;

    /**
     * 退单开始日期
     */
    private String recallStartDate;

    /**
     * 退单结束日期
     */
    private String recallEndDate;

    /**
     * 查询类型：D：扣减额度清单，R：退还额度清单
     */
    private String searchType;

    /**
     * 增加费用类型
     */
    private String feeType;

    /**
     * 是显示机构还是主体
     */
    private Boolean isOrg;

    /**
     * 每页记录数
     */
    private Integer limit = 20;

    /**
     * 页码
     */
    private Integer page = 1;
}
