package com.rocogz.syy.equity.dto.equity.batchDistributionApply.bagent;

import com.rocogz.syy.equity.enumerate.StatisPayWayEnum;
import com.rocogz.syy.equity.enumerate.StatisTimeRangeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author zhangmin
 * @since 2021-06-07
 * 团队 个人数据统计
 */
@Getter @Setter @Accessors(chain = true)
public class GrantStatisSummaryDto {

    //统计的时间范围
    private StatisTimeRangeEnum timeRange;


    //统计的支付方式
    private StatisPayWayEnum payWay;

    /**
     * 总业务笔数
     */
    private Integer totalBusinessNum;

    /**
     * 总金额
     */
    private BigDecimal totalAmt;


    public BigDecimal getAverageAmt()  {
        if(totalBusinessNum == null || totalBusinessNum<=0) {
            return BigDecimal.ZERO;
        }

        //保留3位小数，末位进1
       return  totalAmt.divide(new BigDecimal(totalBusinessNum),3, BigDecimal.ROUND_CEILING);
    }

}
