package com.rocogz.syy.equity.dto.equity.batchDistributionApplyNode;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.equity.entity.attachment.EquityAttachment;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 清单工作流相关更新 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-12-16 20:24:53</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class BatchDistributionEditParamDto {

    /**
     * 提交类型：DRAFT-草稿，SUBMIT-提交
     */
    private String submitType;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 清单编号，如果当前编辑的是申请单则此参数设置为null，如果是清单编辑则设置此参数
     */
    private String applyDetailCode;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 主体业务类型
     */
    private String issuingBodyBusinessType;

    /**
     * 费用类型
     */
    private String feeType;

    /**
     * 扣款个人账户
     */
    private String deductionPersonAccountNo;

    /**
     * 扣款主体账户
     */
    private String deductionIssuingAccountNo;

    /**
     * 批量发券申请单清单
     */
    @TableField(exist = false)
    private List<EquityBatchDistributionCouponApplyDetail> batchDistributionDetailList;

    /**
     * 申请单附件表
     */
    @TableField(exist = false)
    private List<EquityAttachment> equityAttachmentList;
}
