package com.rocogz.syy.equity.dto.equity.oilCardUserCoupon;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 主体可用积分 service</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-07-08 13:31:13</dd>
 * <dd>@author：Andy</dd>
 * <dd>@description：Andy 2023-03-01 09:53:22 增加手机号</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class IssuingBodyAvailableAmountDto {

    /**
     * 主体编号
     */
    private String sourceCode;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 证件号码
     */
    private String idCardExplicit;

    /**
     * 使用规则编码
     */
    private String useRuleCode;

    /**
     * 可用总积分
     */
    private BigDecimal totalAmount;

    /**
     * 费率（手续费）
     */
    private BigDecimal rate;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}
