package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.userCoupon.EquityUserCouponInfo;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 发放用户券请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-03-10 16:00:56</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class UserCouponRecieveParamPADto {
    /**
     * 绑定手机号
     */
    @NotNull(message = "绑定手机号" + EquityConstants.EMPTY_MESSAGE)
    private String bindMobile;

    /**
     * 用户号
     */
    private String userCode;

    /**
     * openId
     */
    @NotNull(message = "openId" + EquityConstants.EMPTY_MESSAGE)
    private String openId;

    /**
     * 待领取的用户券列表
     */
    private List<EquityUserCouponInfo> equityUserCouponInfoList;

    /**
     * 品牌
     */
    private String brand;

}
