package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.issuingBody.IssuingBody;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: 批量发券审核规则配置 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-01-23 17:50:04</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
    @TableName("equity_batch_distribution_apply_limit_config")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionApplyLimitConfig extends UserTimeEntity {

    private static final long serialVersionUID=1L;
    /**
     * 编号
     */
    private String code;

    /**
     * 规则名称
     */

    private String name;

    /**
     * 类型
     * @see com.rocogz.syy.equity.EquityConstants.EquityBatchApplyLimitTypeRule
     * 数量规则：QUANTITY_RULE
     */

    private String type;

    /**
     * 发放主体
     */

    private String sourceCode;

    /**
     * 限制数量/金额的值 与type对应
     */

    private Integer limitQuantity;


    /**
     * 面额修改规则 当type:AMOUNT_RULE 时起作用
     * Y:可修改面额  N：不可修改面额 NULL
     * @see EquityConstants#COMMON_FLAG_Y
     */
    private String faceModify;

    /**
     * 可修改面额时 faceModify:Y 存储的修改类型：NULL,ALL(不限制),MIN(只能改小),MAX(只能改大)
     *
     * @see EquityConstants.DictEquityApplyLimitConfigFaceModifyType#ALL
     */
    private String faceModifyType;

    /**
     * 状态：启用，停用
     */

    private String status;

    /**
     * 规则的内容描述 主要是 列表中需要展示中文，实现存好
     */
    private String conditionRuleName;

    /**
     * 总张数(已发放、已领取、初始、发放失败、待审核）
     */
    @TableField(exist = false)
    private String tmpTotalQuantity;

    /**
     * 已发放张数(已发放、已领取）
     */
    @TableField(exist = false)
    private String tmpGrantQuantity;

    /**
     * 发放中张数(初始、发放失败)
     */
    @TableField(exist = false)
    private String tmpInGrantQuantity;

    /**
     * 待审核张数(待审核)
     */
    @TableField(exist = false)
    private String tmpApproveQuantity;

    /**
     * 发放主体
     */
    @TableField(exist = false)
    private IssuingBody issuingBody;

    //关系
    /**
     * 包含的条件类型
     */
    private transient List<EquityBatchDistributionApplyLimitConfigCondition> conditions;


    //传输为了编辑和展示方便
    /**
     * ctype的字典名称
     */
    private transient String dictName;

    /**
     * type的字典描述
     */
    private transient String dictDesc;

    /**
     * type字典状态
     */
    private transient String dictStatus;

    /**
     * 传输字典为了记录日志调整时，可以将变动的字典项转转化为中文名字记录
     * 包括了LimitType,condition中的字典
     */
    private transient Map<String,String> dictMap;

}
