package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券投放信息表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:13:09</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_launch_info")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponLaunchInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 生效方式：POINT_DATE:指定日期, NOW:领取即生效, LAST_DAY:领取XX天后生效, POLICY_DATE:保单生效日期XX天后生效
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String effectiveModel;

    /**
     * 生效值：当时生效方式为指定日期时此字段为：yyyy-MM-dd，其他方式为数字，0表示领取即生效
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String effectiveValue;

    /**
     * 失效方式：POINT_DATE:指定日期, LAST_DAY:领取XX天后失效, POLICY_DATE:保单失效日期XX天后失效
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String invalidModel;

    /**
     * 失效值：当失效方式为指定日期时此字段为：yyyy-MM-dd,其他方式为数字，0表示领取即失效
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String invalidValue;

    /**
     * 订单失效方式：COUPON_INVALID:优惠券失效日期相同, COUPON_LAST_DAY_INVALID:指定优惠券失效XX天后失效
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String orderInvalidModel;

    /**
     * 订单失效值：为0表示与优惠券失效方式相同、否则指定yyyy-MM-dd
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String orderInvalidValue;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 优惠券发放总张数:999999999：不限张数
     */
    private Integer totalQuantity;

    /**
     * 已发放张数
     */
    private Integer grantQuantity;

    /**
     * 投放平台，多平台竖线区分
     */
    private String platformCode;

    /**
     * 优惠券状态
     */
    @TableField(exist = false)
    private String status;


}
