package com.rocogz.syy.equity.entity.issuingBody;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 主体账户发放产品限制比例信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-12-22 19:01:20</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_issuing_body_account_product_limit_rate")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityIssuingBodyAccountProductLimitRate extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主体编号
     */
    private String issuingCode;

    /**
     * 主体账户编号
     */
    private String issuingAccountCode;

    /**
     * 产品编号
     */
    private String productCode;

    /**
     * 发放总数量
     */
    private Integer totalQuantity;

    /**
     * 发放总额度
     */
    private BigDecimal totalAmount;

}
