package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券加油信息表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-08-09 10:03:05</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_refueling_infomation")
public class EquityUserCouponRefuelingInfomation extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 供应链订单编号
     */
    private String orderItemCode;

    /**
     * 油站编号
     */
    private String oilStation;

    /**
     * 油站名称
     */
    private String oilStationName;

    /**
     * 油枪编号
     */
    private String oilGun;

    /**
     * 油枪名称
     */
    private String oilGunName;

    /**
     * 油品/油号，如：92，95
     */
    private String oilNo;

    /**
     * 油品/油号名称，如92#，95#
     */
    private String oilNoName;

    /**
     * 加油升数，如：5.6L
     */
    private BigDecimal oilVolume;

    /**
     * 加油金额
     */
    private BigDecimal oilAmount;

    /**
     * 用户券状态
     */
    @TableField(exist = false)
    private String status;

    /**
     * 用户券第三方编号
     */
    @TableField(exist = false)
    private String thirdCode;

    /**
     * 用户券使用时间
     */
    @TableField(exist = false)
    private LocalDateTime useTime;

}
