package com.rocogz.syy.equity;

import com.rocogz.syy.equity.dto.issuingBody.IssuingBodyRuleQueryDto;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionApplyLimitConfigNode;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail;
import com.rocogz.util.DateUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;

/**
 * <dl>
 * <dd>Description: 权益工具类 </dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-05-12 08:48:46</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public class EquityCommonUtil {

    /**
     * 获取日期
     * @param model 模式
     * @param modeVal 值
     * @param type E:生效, I:失效
     * @description 备注：如果传入的model不是 POLICY_DATE则 pointDate传入null
     * @return
     */
    public static LocalDateTime getEffectiveInvalidDateByMode(String model, String modeVal, String type, LocalDate pointDate){
        LocalDateTime localDateTime = null;
        if(EquityConstants.COUPON_LAUNCH_INFO_DATE_NOW.equals(model)){   //领取即生效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(LocalDate.now().toString() + DateUtil.START_TIME);
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_POINT_DATE.equals(model)){ //指定日期
            localDateTime = DateUtil.formatDateStrToLocalDateTime(modeVal + ("E".equals(type) ? DateUtil.START_TIME : DateUtil.END_TIME ));
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_LAST_DAY.equals(model)){//领取后几天生效
//            localDateTime = DateUtil.formatDateStrToLocalDateTime(LocalDate.now().plusDays(
//                    "E".equals(type) ? Long.valueOf(modeVal) : Long.valueOf(modeVal) -1) + ("E".equals(type) ? DateUtil.START_TIME : DateUtil.END_TIME));
            localDateTime = DateUtil.formatDateStrToLocalDateTime(LocalDate.now().plusDays(Long.valueOf(modeVal)) + ("E".equals(type) ? DateUtil.START_TIME : DateUtil.END_TIME));
        }else if(EquityConstants.COUPON_LAUNCH_INFO_DATE_MODEL_POLICY_DATE.equals(model)){  //保单日期XX天生效/失效
//            localDateTime = DateUtil.formatDateStrToLocalDateTime(pointDate.plusDays(
//                    "E".equals(type) ? Long.valueOf(modeVal) : Long.valueOf(modeVal) -1) + ("E".equals(type) ? DateUtil.START_TIME : DateUtil.END_TIME));
            localDateTime = DateUtil.formatDateStrToLocalDateTime(pointDate.plusDays(Long.valueOf(modeVal)) + ("E".equals(type) ? DateUtil.START_TIME : DateUtil.END_TIME));
        }
        return localDateTime;
    }

    /**
     *  根据订单失效期方式、订单失效期值、用户券失效日期计算订单失效日期
     * @param orderInvalidModel 订单失效期方式
     * @param orderInvalidValue 订单失效期值
     * @param userCouponInvalidDate 用户券失效日期
     * @return
     */
    public static LocalDateTime getOrderInvalidDate(String orderInvalidModel, String orderInvalidValue, LocalDateTime userCouponInvalidDate){
        if(EquityConstants.COUPON_LAUNCH_INFO_COUPON_LAST_DAY_INVALID.equals(orderInvalidModel)){ //优惠券失效日期XX天后失效
            return userCouponInvalidDate.plusDays(Long.valueOf(orderInvalidValue));
        }
        return userCouponInvalidDate;
    }

    /**
     * 根据传入小时计算所在时间段（上午、下午、晚上）
     * @param hour
     * @return
     */
    public static String convertTimeInRegion(Integer hour){
        if(hour >= 0 && hour < 12){
            return EquityConstants.COMMON_FLAG_AM;
        }else if(hour >= 12 && hour < 18){
            return EquityConstants.COMMON_FLAG_PM;
        }else {
            return EquityConstants.COMMON_FLAG_NIGHT;
        }
    }

    /**
     * 首位截取
     * @param param 参数
     * @param value 位数
     * @return
     */
    private static String beforeSplit(String param, String value){
        if(param.length() <= Integer.parseInt(value)){
            return param;
        }else {
            return param.substring(0, Integer.parseInt(value));
        }
    }

    /**
     * 后位截取
     * @param param 参数
     * @param value 位数
     * @return
     */
    private static String afterSplit(String param, String value){
        if(param.length() <= Integer.parseInt(value)){
            return param;
        }else {
            return param.substring(param.length() - Integer.parseInt(value), param.length());
        }
    }

    /**
     * 生成规则签名
     * @param ruleMap   规则
     * @param name      姓名
     * @param mobile    手机号
     * @param licenseNo 车牌号
     * @param idCard    证件号码
     * @return
     */
    public static String generateRuleSigna(Map<String, String> ruleMap, String name, String mobile, String licenseNo, String idCard){
        MultiValueMap multiValueMap = new LinkedMultiValueMap();
        for(Map.Entry<String, String> entry : ruleMap.entrySet()){
            if(EquityConstants.RECEIVE_RULE_NAME.equals(entry.getKey()) && StringUtils.isNotBlank(name)){
                multiValueMap.add(entry.getKey(), EquityConstants.COMMON_FLAG_Y.equals(entry.getValue()) ? name : "");
            }
            if(EquityConstants.RECEIVE_RULE_MOBILE_BEFORE_N.equals(entry.getKey()) && StringUtils.isNotBlank(mobile)){
                multiValueMap.add(entry.getKey(), beforeSplit(mobile, entry.getValue()));
            }
            if(EquityConstants.RECEIVE_RULE_MOBILE_AFTER_N.equals(entry.getKey()) && StringUtils.isNotBlank(mobile)){
                multiValueMap.add(entry.getKey(), afterSplit(mobile, entry.getValue()));
            }
            if(EquityConstants.RECEIVE_RULE_CARNUMBER_AFTER_N.equals(entry.getKey()) && StringUtils.isNotBlank(licenseNo)){
                multiValueMap.add(entry.getKey(), afterSplit(licenseNo, entry.getValue()));
            }
            if(EquityConstants.RECEIVE_RULE_IDCARD_AFTER_N.equals(entry.getKey()) && StringUtils.isNotBlank(idCard)){
                multiValueMap.add(entry.getKey(), afterSplit(idCard, entry.getValue()));
            }
        }
        return signatureStr(multiValueMap);
    }

    /**
     * 生成签名(前端领券使用）- 平安专用
     * @param mobile        手机号
     * @param licenseNo     车牌号
     * @param name          姓名
     * @param idCard        证件号码
     * @return
     */
    public static String generateRuleSigna(String name, String mobile, String licenseNo, String idCard){
        MultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add(EquityConstants.RECEIVE_RULE_MOBILE_BEFORE_N, beforeSplit(mobile, "3"));
        multiValueMap.add(EquityConstants.RECEIVE_RULE_MOBILE_AFTER_N, afterSplit(mobile,"4"));
        multiValueMap.add(EquityConstants.RECEIVE_RULE_CARNUMBER_AFTER_N, afterSplit(licenseNo,"3"));
        multiValueMap.add(EquityConstants.RECEIVE_RULE_NAME, name);
        if(StringUtils.isNotBlank(idCard)){
            multiValueMap.add(EquityConstants.RECEIVE_RULE_IDCARD_AFTER_N, afterSplit(idCard,"6"));
        }
        return signatureStr(multiValueMap);
    }

    /**
     * 生成签名字符串
     * @param parameters
     * @return
     */
    private static String signatureStr(MultiValueMap<String,String> parameters){
        StringBuilder tempStr = new StringBuilder();
        //将value放到 treeSet中排序，  采用默认排序即可
        TreeSet<String> values = new TreeSet();
        for (String key : parameters.keySet()) {
            if(StringUtils.isNotBlank(parameters.get(key).get(0))){
                values.add(parameters.get(key).get(0));
            }
        }
        // 排序并拼接参数值（按值的升序排序）
        for (String val : values) {
            tempStr.append(val);
        }
        return tempStr.toString();
    }

    /**
     * 发券异常审核：规则条件SQL
     * @param conditionList     条件列表
     * @param ruleNode          规则节点
     * @param detailEntity      清单数据
     * @return
     */
    public static Map<String, String> batchDetailSearchSql(List<String> conditionList, EquityBatchDistributionApplyLimitConfigNode ruleNode, EquityBatchDistributionCouponApplyDetail detailEntity){
        Map<String, String> map = new HashMap<>();
        StringBuffer sql = new StringBuffer();
        StringBuffer key = new StringBuffer();
        if(!"*".equals(ruleNode.getBusinessType())){
            sql.append(" AND detail.issuing_body_business_type='").append(detailEntity.getIssuingBodyBusinessType()).append("'");
            key.append(detailEntity.getIssuingBodyBusinessType());
        }
        if(!"*".equals(ruleNode.getCustomerType())){
            sql.append(" AND detail.business_customer_type='").append(detailEntity.getBusinessCustomerType()).append("'");
            key.append(detailEntity.getBusinessCustomerType());
        }
        if(!"*".equals(ruleNode.getProductType())){
            sql.append(" AND detail.coupon_type_code='").append(detailEntity.getCouponTypeCode()).append("'");
            key.append(detailEntity.getCouponTypeCode());
        }
        if(CollectionUtils.isNotEmpty(conditionList)){
            /** 手机号 **/
            if(conditionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.MOBILE)){
                if(StringUtils.isNotBlank(detailEntity.getMobile())){
                    sql.append(" AND detail.mobile='").append(detailEntity.getMobile()).append("'");
                }else{
                    sql.append(" AND detail.mobile is null");
                }
                key.append(detailEntity.getMobile());
            }

            /** 姓名 **/
            if(conditionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.NAME)){
                if(StringUtils.isNotBlank(detailEntity.getName())){
                    sql.append(" AND detail.name='").append(detailEntity.getName()).append("'");
                }else{
                    sql.append(" AND detail.name is null");
                }
                key.append(detailEntity.getName());
            }

            /** 车牌号 **/
            String licenseNo = detailEntity.getLicenseNo();
            if(StringUtils.isNotBlank(licenseNo)){
                /** 车牌号后三位 **/
                if(conditionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.LICENSE_NO_AFTER_THREE)){
                    String tmplicenseNo = licenseNo.length() >3 ? licenseNo.substring(licenseNo.length()-3, licenseNo.length()) : licenseNo;
                    sql.append(" AND detail.license_no like '%").append(tmplicenseNo).append("'");
                    key.append(tmplicenseNo);
                }
                /** 完整车牌号 **/
                if(conditionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.FULL_LICENSE_NO)){
                    sql.append(" AND detail.license_no='").append(licenseNo).append("'");
                    key.append(licenseNo);
                }
            }else{
                if(conditionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.LICENSE_NO_AFTER_THREE) ||
                        conditionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.FULL_LICENSE_NO)){
                    sql.append(" AND detail.license_no is null");
                }
            }

            /** 车架号 **/
            if(conditionList.contains(EquityConstants.EquityBatchApplyLimitTypeRuleCondition.VIN_NO)){
                if(StringUtils.isNotBlank(detailEntity.getVinNo())){
                    sql.append(" AND detail.vin_no='").append(detailEntity.getVinNo()).append("'");
                }else{
                    sql.append(" AND detail.vin_no is null");
                }
                key.append(detailEntity.getVinNo());
            }

            map.put(EquityConstants.SEARCH_SQL_KEY, sql.toString());
            map.put(EquityConstants.PARAM_KEY, key.toString());
        }
        return map;
    }

    /**
     * 使用规则SQL生成
     * @param useRuleCode       使用规则编码:NAME 或 NAME|PHONENUMBER
     * @param idCardExplicit    证件号码
     * @param name              姓名
     * @param mobile            手机号
     * @param isWithdrawals     是否提现
     * @return
     */
    public static String pointUseRuleSql(String useRuleCode, String idCardExplicit, String name, String mobile, boolean isWithdrawals){
        String searchSql = "";
        if(isWithdrawals){
            if(StringUtils.isNotBlank(useRuleCode)){ //有规则
                String[] ruleCodeStr = useRuleCode.split("\\|");
                searchSql += " AND point.use_rule_code='" + useRuleCode +"'";
                for(int i=0;i<ruleCodeStr.length;i++){
                    switch (ruleCodeStr[i]){
                        case EquityConstants.USE_RULE_NAME:
                            searchSql += " AND point.user_name='" + (StringUtils.isNotBlank(name) ? name : "") + "'";
                            break;
                        case EquityConstants.USE_RULE_PHONENUMBER:
                            searchSql += " AND point.mobile='" + (StringUtils.isNotBlank(mobile) ? mobile : "") + "'";
                            break;
                        case EquityConstants.USE_RULE_CARNUMBER:
                            searchSql += " AND point.id_card_explicit='" + (StringUtils.isNotBlank(idCardExplicit) ? idCardExplicit : "") + "'";
                            break;
                        default:
                            break;
                    }
                }
            }else{ //无规则
                searchSql = " AND point.use_rule_code is null ";
            }
        }
        return searchSql;
    }

    /**
     * 转换当前年月日为年yyyy
     * @return
     */
    public static String convertNowDateToYear(LocalDate nowDate){
        return String.valueOf(nowDate.getYear());
    }

    /**
     * 转换创建时间为年份
     * @param createTime 创建时间
     * @return
     */
    public static String convertCreatTimeToYear(LocalDateTime createTime){
        return createTime.toString().substring(0, 4); //清单申请年份
    }

    /**
     * 计算商业险保费比例
     * @param amount                    总额度
     * @param businessInsurancePremium  商业险保费
     * @description rate = amount/businessInsurancePremium
     *              Andy 2022-10-31 15:24:10 调整判断商业险保费允许为0的情况不参与计算
     * @return
     */
    public static BigDecimal computeBusinessInsuranceRate(BigDecimal amount, BigDecimal businessInsurancePremium){
//        return Objects.nonNull(businessInsurancePremium) ? amount.divide(businessInsurancePremium, 4, RoundingMode.HALF_UP) : null;
        return (Objects.nonNull(businessInsurancePremium) && businessInsurancePremium.compareTo(BigDecimal.ZERO) == 1)  ? amount.divide(businessInsurancePremium, 4, RoundingMode.HALF_UP) : null;
    }

    /**
     * 节点类型为审批则返回待审批，节点类型为审核返回待审核
     * @param nodeType
     * @return
     */
    public static String convertNodeTypeToStatus(String nodeType){
        return EquityConstants.DictIssuingBodyNodeType.APPROVE.equals(nodeType) ? EquityConstants.DictApplyDetailWorkFlowStatus.PENDING_APPROVE : EquityConstants.DictApplyDetailWorkFlowStatus.PENDING_AUDIT;
    }

    /**
     * 转换发送给申请人模板消息中第二个参数
     * @param name
     * @param licenseNo
     * @return
     */
    public static String convertPushCreateUserWxMsgKeyWord2(String name, String licenseNo){
        name = StringUtils.isNotBlank(name) ? name : ""; //姓名
        licenseNo = StringUtils.isNotBlank(licenseNo) ? licenseNo : ""; //车牌号
        String tmpContent;
        if(StringUtils.isBlank(name) && StringUtils.isBlank(licenseNo)){
            tmpContent = "";
        }else if(StringUtils.isNotBlank(name) && StringUtils.isNotBlank(licenseNo)){
            tmpContent = name + "/" + licenseNo;
        }else if(StringUtils.isNotBlank(name) && StringUtils.isBlank(licenseNo)){
            tmpContent = name;
        }else {
            tmpContent = licenseNo;
        }
        return tmpContent;
    }


    /**
     * 生成主体匹配规则的批量匹配的KEY
     * @param dto   入参
     * @return  key
     */
    public static String generateIssuingBodyRuleMatchKey(IssuingBodyRuleQueryDto dto){
        if(dto == null){
            return null;
        }
        return generateWorkFlowNodeKey(dto.getBusinessType(), dto.getCustomerType(), dto.getProductType(), dto.getProductCode());
    }

    /**
     * 生成工作流节点key
     * @param param 参数
     * @return
     */
    public static String generateWorkFlowNodeKey(String... param){
        StringBuffer sb = new StringBuffer();
        for (String s : param) {
            sb.append(s).append("_");
        }
        sb.delete(sb.length()-1, sb.length());
        return sb.toString();
    }

    /**
     * 清单相关字段脱敏
     * @return
     */
    public static EquityBatchDistributionCouponApplyDetail detailColumnDesensitive(EquityBatchDistributionCouponApplyDetail detail){
        /** 手机号 **/
        if(StringUtils.isNotBlank(detail.getMobile())){
            char[] mobileChars = detail.getMobile().toCharArray();
            for(int i=3; i<7 && i<mobileChars.length;i++){
                mobileChars[i] = '*';
            }
            detail.setMobile(new String(mobileChars));
        }

        /** 姓名 **/
        if(StringUtils.isNotBlank(detail.getName())){
            char[] nameChars = detail.getName().toCharArray();
            for(int i=1; i<detail.getName().length() && i<nameChars.length;i++){
                nameChars[i] = '*';
            }
            detail.setName(new String(nameChars));
        }

        /** 车牌号 **/
        if(StringUtils.isNotBlank(detail.getLicenseNo())){
            char[] licenseNoChar = detail.getLicenseNo().toCharArray();
            for(int i=0; i<3 && i<licenseNoChar.length;i++){
                licenseNoChar[i] = '*';
            }
            detail.setLicenseNo(new String(licenseNoChar));
        }

        /** 车架号 **/
        if(StringUtils.isNotBlank(detail.getVinNo())){
            int start = 0;
            int end = 0;
            String vinNo = detail.getVinNo();
            if(vinNo.length() == 1){
                end = 1;
            }else if(vinNo.length() > 1 && vinNo.length() <=3){
                start = 1;
                end = vinNo.length();
            }else if((vinNo.length() >3 && vinNo.length() <6) || vinNo.length() == 6){
                end = 3;
            }else if(vinNo.length() > 6){
                end = vinNo.length()-6;
            }
            char[] vinNoChars = detail.getVinNo().toCharArray();
            for(int i=start; i<end && i<vinNoChars.length;i++){
                vinNoChars[i] = '*';
            }
            detail.setVinNo(new String(vinNoChars));
        }
        return detail;
    }

}
