package com.rocogz.syy.equity.dto.equity.batchDistributionApply.bagent;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 首页-> 新发券统计客户赠送记录金额【统计的发放清单】 dto</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2023-07-07 13:18:45</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Getter @Setter @Accessors(chain = true)
public class CustomerGivenRecordAmountWorkFlowDto {

    /**
     * 申请人用户名
     */
    private String applyUserName;

    /**
     * 总金额: 全部清单状态
     */
    private BigDecimal totalAmount;

    /**
     * 待审金额:  清单状态【DRAFT】
     */
    private BigDecimal pendingExamAmount;

    /**
     * 待审核金额:  清单状态【待审核】
     */
    private BigDecimal pendingApproveAmount;

    /**
     * 处理中金额: 状态清单【待处理、处理中、作废中、失败、作废失败】
     */
    private BigDecimal  inProcessAmount;

    /**
     * 已发放金额: 状态清单【已发放、撤回中】
     */
    private BigDecimal  grantedAmount;

    /**
     * 已作废金额 (已作废状态包含：已作废、已撤回、申请不通过,审核不通过)
     */
    private BigDecimal invalidAmount;

}
