package com.rocogz.syy.equity.dto.equity.batchDistributionApply.bagent;

import com.rocogz.syy.equity.enumerate.QueryGivenRecordTabType;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author zhangmin
 * @since 2021-05-21
 * 首页-> B端礼赠订单-> 客户赠送记录查询参数
 * @description Andy 2023-07-10 22:03:09 新增申请开始日期、申请结束日期、产品类别查询条件
 */
@Getter
@Setter
@Accessors(chain = true)
public class CustomerGivenRecordSearchParamDto {

    private Integer limit = 10;

    private Integer page = 1;

    /**
     * 申请人用户名
     */
    private String applyUserName;

    /**
     * 发放主体编号
     */
    private List<String> issuingBodyCodeList;

    /**
     * 团队编号
     */
    private List<String> teamCodeList;

    /**
     * 申请开始日期
     */
    private String applyStartDate;

    /**
     * 申请结束日期
     */
    private String applyEndDate;

    /**
     * 发放开始日期
     */
    private String grantStartDate;

    /**
     * 发放结束日期
     */
    private String grantEndDate;

    /**
     * 产品类别（优惠券类型）
     */
    private String couponTypeCode;

    /**
     * 产品类别（此字段用于转换产品类别:couponTypeCode字段数据权限多个参数值时，根据逗号拆分设置到此字段中，请不要单独设置此字段参数值）
     */
    private List<String> couponTypeCodeList;

    /**
     * 业务类型
     */
    private String businessType;


    //手机号/车牌号/车架号 关键词
    private String customerMobile;


    private QueryGivenRecordTabType queryTab = QueryGivenRecordTabType.ALL;


    public String getCustomerMobileKeyWord() {
        if (StringUtils.isBlank(customerMobile)) {
            return null;
        }

        return StringUtils.wrap(customerMobile.trim(), "%");
    }

}
