package com.rocogz.syy.equity.dto.equity.batchDistributionApply.bagent;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @author zhangmin
 * @since 2021-05-21
 * 首页-> 统计客户赠送记录数量【统计的发放清单】
 */
@Getter @Setter @Accessors(chain = true)
public class CustomerGivenRecordSummaryDto {

    /**
     * 申请人用户名
     */
    private String applyUserName;

    /**
     * 总赠送记录数量: 全部清单状态
     */
    private Integer totalNum;

    /**
     * 待审批数量:  清单状态【DRAFT】
     */
    private Integer pendingExamNum;

    /**
     * 待审核数量:  清单状态【待审核】
     */
    private Integer pendingApproveNum;

    /**
     * 处理中数量: 状态清单【待处理、处理中、作废中、失败、作废失败】
     */
    private Integer  inProcessNum;

    /**
     * 已发放数量: 状态清单【已发放、撤回中】
     */
    private Integer  grantedNum;

    /**
     * 已领取赠送记录数: 状态清单是【已发放、撤回中】且【已领取】
     */
    private Integer receivedNum;


    /**
     * 未领取赠送记录数: 状态清单【已发放、撤回中】且【未领取】
     */
    private Integer unReceiveNum;

    /**
     * 已作废数量 (已作废状态包含：已作废、已撤回、申请不通过,审核不通过)
     */
    private Integer invalidNum;

}
