package com.rocogz.syy.equity.dto.equity.recall;



import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.entity.attachment.EquityAttachment;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <dl>
 * <dd>Description:撤回申请单的保存DTO </dd>
 * <dd>@date: 2021/08/11</dd>
 * <dd>@author: huhailong</dd>
 * @description：Andy 2022-12-16 13:06:28 增加创建人姓名、手机号
 * </dl>
 */
@Data
public class RecallApplySaveReq  {

    /***
     * 要撤回的清单编号
     */
    @NotBlank(message = "请传递清单编号")
    private String applyDetailCode;

    /**
     * 撤回原因
     */
    private String recallReason;

    /**
     * 创建人
     */
    @NotBlank
    private String operator;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 操作人手机号
     */
    private String operatorMobile;

    /**
     * 附件列表
     */
    private List<EquityAttachment> attachmentList;


    /**
     * 检查请求
     * @return
     */
    public Response checkReq() {
        if (CollectionUtils.isEmpty(attachmentList)) {
            return Response.failure("请传递撤回凭证　");
        }
        return Response.succeed();
    }




}
