package com.rocogz.syy.equity.dto.equity.rule;

import com.rocogz.syy.equity.entity.rule.GiftRuleBusinessType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Data
@Accessors(chain = true)
public class EquityInssuingGiftRuleDto {

    private Integer id;

    /**
     * 规则编号
     */
    private String giftRuleCode;

    /**
     * 业务编号
     */
    private String businessCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 成本统计对象
     */
    private String ruleObjects;

    /**
     * 成本统计对象
     */
    private String ruleObjectsName;

    /**
     * 项目赠送成本红线金额
     */
    private BigDecimal costRedLineAmount;

    /**
     *
     状态 启用OPEN,  停用LOCK
     */
    private String giftRuleStatus;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     *是否全部业务类型
     */
    private Boolean isAll = false;

    /**
     * 业务类型
     */
    private List<GiftRuleBusinessType> businessTypeList;
    /**
     * 业务类型
     */
    private Map<String, String> businessTypeMap;

    /**
     * 当前页码
     */
    Integer page;

    /**
     * 每页数量
     */
    Integer limit;
}
