package com.rocogz.syy.equity.dto.equity.smsMerge;

import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券撤回、作废请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-04-26 17:17:46</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class SmsMergeInfoParamDto {

    /**
     * 清单编号
     */
    @NotNull(message = "清单编号" + EquityConstants.EMPTY_MESSAGE)
    private String applyDetailCode;

    /**
     * 领取结束日期
     */
    private LocalDateTime receiveInvalidDate;

    /**
     * 短信模板编号
     */
    @NotNull(message = "短信模板编号" + EquityConstants.EMPTY_MESSAGE)
    private String smsModelCode;

    /**
     * 短信延迟时间
     */
    @NotNull(message = "短信延迟时间" + EquityConstants.EMPTY_MESSAGE)
    private Integer sendTimeValue;
}
