package com.rocogz.syy.equity.dto.equity.template;

import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.entity.template.EquityIssuingTemplateColumnDict;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * <dl>
 * <dd>Description:查询权益模版列自定义字典 </dd>
 * <dd>@date: 2021/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class EquityIssuingTemplateColumnDictSaveReq {

    /**
     * 发放主体bodyCode
     */
    private String issuingBodyCode;
    /**
     * 模版Code
     */
    private String templateCode;

    /**
     * 模版列Code
     */
    private String columnCode;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


    /**
     *模版列的字典数据
     */
    List<EquityIssuingTemplateColumnDict> dictList;


    //检查数据
    public Response checkData(){

        if(StringUtils.isAnyBlank(this.issuingBodyCode,this.templateCode,this.columnCode)){
           return Response.failure("请检查发放主体编号,模版编码，模版列编码参数是否传传递");
        }
        int index=1;
        for (EquityIssuingTemplateColumnDict dict : dictList) {
            if(StringUtils.isAnyBlank(dict.getColumnCode(), dict.getTemplateCode(), dict.getIssuingBodyCode(),
                    dict.getBusinessCode(),dict.getName(),dict.getStatus())
                    || Objects.isNull(dict.getSort())){
                return Response.failure("请检查第"+index+"行数据是否完整");
            }
            index++;
        }
        return Response.succeed();

    }
}
