package com.rocogz.syy.equity.dto.equity.template;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 查询发放主体关联的客户类型 - 查询参数</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/8/9 14:57</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
public class IssuingBodyRelateCustomerTypeReq {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 主体业务类型编号
     */
    private List<String> includeBusinessCodes;

    /**
     * 客户类型编号
     */
    private List<String> includeCustomerCodes;

    /**
     * 客户类型编号
     */
    private List<String> excludeCustomerCodes;

    /**
     * 客户类型状态
     */
    private String status;

    /**
     * 分页
     */
    private Integer limit = 20;
    /**
     * 当前第几页
     */
    private Integer page = 1;
}
