package com.rocogz.syy.equity.dto.issuingBody;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 发放主体规则匹配的Dto对象
 * </p>
 *
 * @author 陈煜敏
 * @since 2023-08-04
 */
@Data
@Accessors(chain = true)
public class IssuingBodyRuleQueryDto {

    /**
     * 主体编号
     */
    private String issuingBodyCode;

    /**
     * 规则编号，一般不传，如果传了表示确定了规则，只是为了匹配具体的节点
     */
    private String ruleCode;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 客户类型
     */
    private String customerType;

    /**
     * 产品类别
     */
    private String productType;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 状态
     */
    private String status;

}
