package com.rocogz.syy.equity.dto.issuingBodyCostStat;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 主体项目赠送成本统计请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023-09-20 15:11:05</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class IssuingBodyProjectCostStatListParamDto {

    /**
     * 主体编号
     */
    private String issuingBodyCodes;

    /**
     * 业务类型
     */
    private String businessTypeCodes;

    /**
     * 产品类别
     */
    private String productType;

    /**
     * 车牌号（模糊）
     */
    private String likeLicenseNo;

    /**
     * 车架号（模糊）
     */
    private String likeVinNo;

    /**
     * 保单号
     */
    private String likePolicyNo;

    /**
     * 保单年度
     */
    private String policyYear;

    /**
     * 续保员
     */
    private String renewalInsurePerson;

    /**
     * 申请人
     */
    private String createUser;

    /**
     * 发放开始月份
     */
    private String grantStartMonth;

    /**
     * 发放结束月份
     */
    private String grantEndMonth;

    /**
     * 发放开始日期
     */
    private String grantStartDate;

    /**
     * 发放结束日期
     */
    private String grantEndDate;

    /**
     * 每页记录数
     */
    private Integer limit = 20;

    /**
     * 页码
     */
    private Integer page = 1;

}
