package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 批量发券审核规则配置节点表
 * </p>
 * @author 陈煜敏
 * @since 2023-08-03
 */
@TableName(value = "equity_batch_distribution_apply_limit_config_node")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
public class EquityBatchDistributionApplyLimitConfigNode extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 规则编号
     */
    private String configCode;

    /**
     * 主体编号
     */
    private String sourceCode;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 客户类型
     */
    private String customerType;

    /**
     * 产品类别
     */
    private String productType;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 业务类型名称
     */
    @TableField(exist = false)
    private String businessName;

    /**
     * 客户类型名称
     */
    @TableField(exist = false)
    private String customerName;

    /**
     * 产品类型名称
     */
    @TableField(exist = false)
    private String productTypeName;

    /**
     * 产品名称
     */
    @TableField(exist = false)
    private String productName;

    /**
     * 排序号，根据产品>产品类型>客户类型>业务类型的形式进行从大到小排序
     */
    @TableField(exist = false)
    private int sort;

}
