package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.template.EquityIssuingTemplateColumnDict;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

import static com.rocogz.syy.equity.EquityConstants.COMMON_FLAG_APPROVE;
import static com.rocogz.syy.equity.EquityConstants.COMMON_FLAG_N;
import static com.rocogz.syy.equity.EquityConstants.COMMON_FLAG_Y;

/**
 * <dl>
 * <dd>Description: 批量发券申请单清单 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:54</dd>
 * <dd>@author：Andy</dd>
 * <description>
 *     Andy 2023-03-09 10:32:56 增加保司费用点数、保司费用金额、是否超出保司点数、本单加投金额
 * </description>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply_detail")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApplyDetail extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 发券性质
     */
    private String nature;

    /**
     * 申请单类型,即发放渠道
     *
     * @see EquityConstants.DictEquityApplyType
     */
    private String applyType;

    /**
     * 小程序id
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 小程序二维码地址
     */
    @TableField(exist = false)
    private String miniAppQrUrl;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 发放主体名称(简称)
     */
    @TableField(exist = false)
    private String sourceName;

    /**
     * 发放主体名称(全称)
     */
    @TableField(exist = false)
    private String sourceFullName;

    /**
     * 主体业务类型
     */
    private String issuingBodyBusinessType;

    /**
     * 主体业务类型
     */
    @TableField(exist = false)
    private String issuingBodyBusinessTypeName;

    /**
     * 费用类型
     */
    private String feeType;

    /**
     * 清单编号
     */
    private String code;

    /**
     * 原清单编号
     *
     * @see EquityBatchDistributionCouponApplyOriginDetail#code
     * 如果是历史数据或申请类型是EXCHANGE_RECEIVE的 则为null
     */
    private String originApplyDetailCode;

    /**
     * 平台产品编号
     */
    private String platformProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 仓库编码
     */
    private String whCode;

    /**
     * 产品所属供应商编号
     */
    private String productBelongSupplierCode;

    /**
     * 产品所属供应商名称
     */
    @TableField(exist = false)
    private String productBelongSupplierName;

    /**
     * 产品所属客户编号
     */
    private String productBelongCustomerCode;

    /**
     * 产品所属客户名称
     */
    @TableField(exist = false)
    private String productBelongCustomerName;

    /**
     * 发放规则编码
     */
    private String grantRuleCode;

    /**
     * 领取规则编码
     */
    private String receiveRuleCode;

    /**
     * 扣减时点：领取时扣减：DEDUCTION_ON_COLLECTION， 发放时扣减：DEDUCTION_ON_ISSUE
     */
    private String dedutionTimePoint;

    /**
     * 扣款个人账户
     */
    private String deductionPersonAccountNo;

    /**
     * 扣款主体账户
     */
    private String deductionIssuingAccountNo;

    /**
     * 触发调用上游的方式：MANUAL-手动、AUTO-自动
     * @2022-03-16 17:42:48 Andy
     */
    private String remoteTriggerMode;

    /**
     * 触发调用上游次数
     * @2022-03-16 17:42:48 Andy
     */
    private Integer remoteTriggerQuantity;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 优惠券类型
     */
    private String couponTypeCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 续保员
     */
    private String renewalInsurePerson;

    /**
     * 保费及税款合计(原车险保费)
     */
    private BigDecimal carInsurancePremium;

    /**
     * 商业险保费合计
     */
    private BigDecimal businessInsurancePremium;

    /**
     * 年审日期
     */
    private String yearReviewDate;

    /**
     * 保养日期
     */
    private String maintenanceDate;

    /**
     * 业务员
     */
    private String salesman;

    /**
     * 业务来源
     */
    private String businessSource;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 主体发券类型, 页面显示：发券类型
     * @see EquityIssuingTemplateColumnDict#code
     */
    private String grantCouponType;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 状态：INIT-初始，SUCCESS-成功，FAIL-失败
     * 数据字典：BATCH_DISTRIBUTION_DETAIL_STATUS
     */
    private String status;

    /**
     * 服务商账号显示状态
     */
    private String serviceShowStatus;

    /**
     * 发放主体账号显示状态
     */
    private String issuingBodyShowStatus;

    /**
     * 结算状态
     * @see com.rocogz.syy.equity.EquityConstants.DictBatchDistributionDetailSettleStatus
     */
    private String settleStatus;

    /**
     * 状态显示中文，系统状态/服务商账号状态/发放主体状态
     * 1：当前端获取status时，此字段为status的中文
     * 2：当前前端获取issuingBodyShowStatus时，此字段为issuingBodyShowStatus对应的中文。
     * 3：当前前端获取serviceShowStatus时，此字段为serviceShowStatus对应的中文。
     */
    @TableField(exist = false)
    private String statusDesc;

    /**
     * 是否审核数据：Y-是，N-否
     */
    private String approveFlag;

    /**
     * 发放数量
     */
    private Integer quantity;

    /**
     * 已发放数量
     */
    private Integer grantQuantity;

    /**
     * 此数据在文件内行数
     */
    private Integer rowNum;

    /**
     * 单个产品的 扣减额度
     * （1）代理商产品的   agentProduct.getPurchasePrice() 结算价
     * (2）合作客户产品的 customerProduct.getSettlePrice() 结算价
     */
    private BigDecimal dedutionAmount;

    /**
     *  总扣减额度（此扣减额度 = 单个产品扣减额度*数量）
     * （1）代理商产品的   agentProduct.getPurchasePrice() 结算价
     * (2）合作客户产品的 customerProduct.getSettlePrice() 结算价
     */
    private BigDecimal dedutionTotalAmount;

    /**
     * (1) 单个产品 的单位面值/用户输入的自定义面额(直充或积分)
     * (2) 单个 客户产品/服务商产品 的市场价
     **/
    private BigDecimal unitFaceValue;

    /**
     * 原单位面值
     */
    private BigDecimal originUnitFaceValue;

    /**
     * 领取生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 领取失效日期
     */
    private LocalDate invalidDate;

    /**
     * 使用生效日期
     */
    private LocalDate useEffectiveDate;

    /**
     * 使用失效日期
     */
    private LocalDate useInvalidDate;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 描述
     */
    private String description;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放月份
     */
    private String grantMonth;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 领取状态
     */
    private String receiveStatus;

    /**
     * 过期未领取标记：Y-是, H-过期未领取的隐藏数据, N-否
     */
    private String invalidUnreceiveFlag;

    /**
     * 面值
     */
    @TableField(exist = false)
    private BigDecimal faceValue;

    /**
     * 发放短信次数
     */
    @TableField(exist = false)
    private Integer sendMessageQuantity;

    /**
     * 平台产品 性质
     *
     * @see EquityConstants#GOODS_NATURE_ITEM
     */
    @TableField(exist = false)
    private String goodsNature;

    /**
     * 平台产品类型
     *
     * @see EquityConstants#OIL_CARD_DIGITAL_YES_COUPON
     */
    @TableField(exist = false)
    private String goodsType;


    /**
     * 平台产品市场价格,直充产品拆单后,面额发生变化重新计算dedutionAmount
     */
    @TableField(exist = false)
    private BigDecimal platformProductMarketPrice;

    /**
     * agentProduct.purchasePrice 或 customerProduct.settlePrice,  直充产品拆单后,面额发生变化重新计算dedutionAmount
     */
    @TableField(exist = false)
    private BigDecimal customerOrAgentProductPurchasePrice;

    /**
     * 采购结算单价,用来计算备付金
     */
    @TableField(exist = false)
    private BigDecimal purchaseSettlePrice;

    /**
     * 额度转换成备付金的 转换比例,用来计算备付金
     */
    @TableField(exist = false)
    private BigDecimal quotaConversionRatio;

    /**
     * 注释
     */
    private String notes;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建年份
     */
    private String createYear;

    /**
     * 分拆的现金[B端送礼专属字段]
     */
    private BigDecimal allocatedCash;

    /**
     * 分拆的额度[B端送礼专属字段]
     */
    private BigDecimal allocatedQuota;


    /**
     * 分拆的备付金额度[B端送礼专属字段]
     */
    private BigDecimal allocatedCoverQuota;


    /**
     * 撤回时间
     */
    private LocalDateTime recallTime;

    /**
     * 审核结果
     * @see EquityConstants.DictApproveResult
     */
    private String approveResult;

    /**
     * 审核时间
     */
    private LocalDateTime approveTime;

    /**
     * 审核规则编号
     */
    private String approveRuleCode;

    /**
     * 创建人手机号
     */
    private String createUserMobile;

    /**
     * 保险公司 编号
     * @see EquityIssuingTemplateColumnDict#code
     */
    private String insuranceCompany;

    /**
     * 商业保险费比例
     */
    private BigDecimal businessInsuranceRate;

    /**
     * 投保人
     */
    private String policyHolderPerson;

    /**
     * 被保人
     */
    private String insuredPerson;

    /**
     * 车主
     */
    private String carOwner;

    /**
     * 出单日期
     */
    private LocalDate policyCreateDate;

    /**
     * 交强险保费合计
     */
    private BigDecimal compulsoryInsurancePremium;

    /**
     * 车船税税款合计
     */
    private BigDecimal vehicleVesselTax;

    /**
     * 其他险种保费合计
     */
    private BigDecimal otherInsurancePremium;

    /**
     * 商业险返点点数
     */
    private BigDecimal businessInsuranceRebate;

    /**
     * 交强险返点点数
     */
    private BigDecimal compulsoryInsuranceRebate;

    /**
     * 商业险返点金额
     */
    private BigDecimal businessInsuranceRebateAmount;

    /**
     * 交强险返点金额
     */
    private BigDecimal compulsoryInsuranceRebateAmount;

    /**
     * 返点合计
     */
    private BigDecimal totalRebate;

    /**
     * 到账日期
     */
    private LocalDate dateOfReceipt;

    /**
     * 保司费用点数
     */
    private BigDecimal insuranceCompanyRebate;

    /**
     * 保司费用金额
     */
    private BigDecimal insuranceCompanyAmount;

    /**
     * 是否超出保司点数：Y、N
     */
    private String insuranceCompanyRebateOverstep;

    /**
     * 是否超出保司点数：是，否
     */
    @TableField(exist = false)
    private String insuranceCompanyRebateOverstepLabel;

    /**
     * 本单加投金额
     */
    private BigDecimal thisOrderAddAmount;

    /**
     * 发放对象编号
     */
    private String grantObjectCode;

    /**
     * 扣减额度主体编号
     */
    private String dedutionSourceCode;

    /**
     * 发放成功时间
     */
    private LocalDateTime grantSuccessTime;

    /**
     * 客户产品类型：MERCHANT_CUSTOMER_GOODS：PLATFORM：平台产品，MERCHANT_CUSTOMER_GOODS：HAVE：自营产品
     */
    private String customerProductType;

    /**
     * 此清单是否工作流：Y-是，N-否
     */
    private String workFlowFlag;

    /**
     * 上级节点编号
     */
    private String preNodeCode;

    /**
     * 上级节点名称
     */
    private String preNodeName;

    /**
     * 上级节点审批人
     */
    private String preNodeApproveUser;

    /**
     * 上级节点审批人姓名
     */
    private String preNodeApproveName;

    /**
     * 上级节点审批人手机号
     */
    private String preNodeApproveMobile;

    /**
     * 上级节点审批时间
     */
    private LocalDateTime preNodeApproveTime;

    /**
     * 上级节点审批结果
     */
    private String preNodeResult;

    /**
     * 工作流状态
     */
    private String workFlowStatus;

    /**
     * 当前节点编号
     */
    private String currentNodeCode;

    /**
     * 当前节点名称
     */
    private String currentNodeName;

    /**
     * 当前节点类型
     */
    private String currentNodeType;

    /**
     * 工作流结束标记：Y-是，N-否
     */
    private String workFlowEndFlag;

    /**
     * 删除标记：Y-已删除，N-未删除
     */
    private String deleteFlag;

    /**
     * 驾意险保费
     */
    private BigDecimal drivingAccidentInsurancePremium;

    /**
     * 驾意险返点点数
     */
    private BigDecimal drivingAccidentInsuranceRebate;

    /**
     * 驾意险返点金额
     */
    private BigDecimal drivingAccidentInsuranceAmount;

    /**
     * 保司分支机构简称
     */
    private String insuranceBranchAbbreviation;
    /**
     * 业务客户类型
     * 实际存的值为： 主体编号_业务类型编号_columnCode固定值（CUSTOMERTYPE）_客户类型编号 拼接而成的字符串
     * eg: EI2021122400002_ROCO_ORG_XB_BUSINESSCUSTOMERTYPE_C001
     */
    private String businessCustomerType;

    /**
     *车型
     */
    private String carModel;
    /**
     *保司商业险返点点数
     */
    private BigDecimal insuranceBusinessRebate;
    /**
     *保司商业险返点金额
     */
    private BigDecimal insuranceBusinessRebateAmount;
    /**
     *保司交强险返点点数
     */
    private BigDecimal insuranceCompulsoryRebate;
    /**
     *保司交强险返点金额
     */
    private BigDecimal insuranceCompulsoryRebateAmount;
    /**
     *保司驾意险返点点数
     */
    private BigDecimal insuranceDrivingAccidentRebate;
    /**
     *保司驾意险返点金额
     */
    private BigDecimal insuranceDrivingAccidentRebateAmount;
    /**
     *保司政策金额合计
     */
    private BigDecimal insurancePolicyTotalAmount;
    /**
     * 出单情况
     */
    private String policySituation;

    /**
     * 服务项目成本价（服务券此字段有值，其他类型券为null)
     */
    private BigDecimal serviceProjectCostPrice;

    /**
     * 实名缴费手机号
     */
    private String realPaymentMobile;

    /**
     * 是否发实名缴费手机号：Y-是，N-否
     */
    private String grantRealPaymentMobileFlag;

    /**
     * 是否发实名缴费手机号中文label
     */
    @TableField(exist = false)
    private String grantRealPaymentMobileFlagLabel;

    /**
     * 非实名缴费手机号说明
     */
    private String unRealPaymentMobileRmk;

    /**
     * 车辆初登日期
     */
    private LocalDate carRegisterDate;

    /**
     * 本单是否退现：Y-是，N-否
     */
    private String thisOrderRefundFlag;

    /**
     * 保单年度
     */
    private String policyYear;

    /**
     * 项目赠送成本统计编号
     */
    private String projectGiveCostCode;

    /**
     * 本单是否退现中文label
     */
    @TableField(exist = false)
    private String thisOrderRefundFlagLabel;

    /**
     * 现金赠送盈余金额
     * equityIssuingBodyProjectGiveCostStat（积分券=清单中的保司政策金额合计 - totalCostAmount， 服务券=0）
     */
    @TableField(exist = false)
    private BigDecimal cashGiftSurplusAmount;

    /**
     * 项目赠送成本红线金额
     * equityIssuingBodyProjectGiveCostStat
     * 表中：redLineAmount = 服务券=规则表配置的红线金额
     */
    @TableField(exist = false)
    private BigDecimal projectGiftCostRedLineAmount;

    /**
     * 项目成本合计金额
     * equityIssuingBodyProjectGiveCostStat
     * 表中：totalCostAmount = 服务券=服务项目成本合计，积分=单位面值合计
     */
    @TableField(exist = false)
    private BigDecimal totalProjectCostAmount;

    /**
     * 项目赠送盈余金额
     * equityIssuingBodyProjectGiveCostStat 表中：redLineAmount - totalCostAmount
     */
    @TableField(exist = false)
    private BigDecimal projectGiftSurplusAmount;

    /**
     * 积分盈余规则开启标志:OPEN-开启，LOCK-关闭
     */
    @TableField(exist = false)
    private String pointCostRuleStatus;

    /**
     * 服务项目盈余规则开启标志：OPEN-开启，LOCK-关闭
     */
    @TableField(exist = false)
    private String servicePorjectCostRuleStatus;

    /**
     * 店内总送积分
     */
    @TableField(exist = false)
    private BigDecimal giveTotalPointAmount;

    /**
     * 出单情况
     */
    @TableField(exist = false)
    private String policySituationLabel;

    /**
     * 附件数量
     */
    @TableField(exist = false)
    private Integer attachmentQuantity;

    /**
     * 显示的发券类型名称
     * @see EquityIssuingTemplateColumnDict#name
     */
    @TableField(exist = false)
    private String grantCouponTypeLabel;

    /**
     * 显示的保险公司名称
     * @see EquityIssuingTemplateColumnDict#name
     */
    @TableField(exist = false)
    private String insuranceCompanyLabel;

    /**
     * 业务客户类型显示名称
     */
    @TableField(exist = false)
    private String businessCustomerTypeLabel;

    /**
     * 主体是否可上传附件
     */
    @TableField(exist = false)
    private String issuingAttachUpload;

    /**
     * 我的审批结果(工作流)
     */
    @TableField(exist = false)
    private String workFlowApproveResult;

    /**
     * 我的审批时间(工作流)
     */
    @TableField(exist = false)
    private LocalDateTime workFlowApproveTime;

    /**
     * 核销状态（用户券的状态，只有服务券才有核销状态的概念）
     */
    @TableField(exist = false)
    private String writeOffStatus;

    /**
     * 撤回人账号
     */
    @TableField(exist = false)
    private String recallUser;

    /**
     * 撤回申请单号
     */
    @TableField(exist = false)
    private String recallApplyNo;

    /**
     * 是否超限审核且修改面额，true-是，false-否
     */
    @TableField(exist = false)
    private boolean approveModifyUnitFaceValueFlag;

    /**
     * 设置状态同时设置服务商账号显示状态、主体账号显示状态
     * @param status
     */
    public EquityBatchDistributionCouponApplyDetail setStatus(String status){
        this.status = status;
        if(StringUtils.isBlank(status)) {
            return this;
        }

        switch (status){
            case EquityConstants.BATCH_DISTRIBUTION_APPLY_DETAIL_STATUS_INIT: //待平台发放
                this.serviceShowStatus = EquityConstants.BATCH_DISTRIBUTION_APPLY_STATUS_IN_PROCESS; //发放中
                this.issuingBodyShowStatus = EquityConstants.BATCH_DISTRIBUTION_APPLY_STATUS_IN_PROCESS; //发放中
                break;
            case EquityConstants.COMMON_FLAG_CANCEL_FAIL: //作废失败
                this.serviceShowStatus = EquityConstants.COMMON_FLAG_IN_CANCEL; //作废中
                this.issuingBodyShowStatus = EquityConstants.COMMON_FLAG_IN_CANCEL; //作废中
                break;
            case EquityConstants.COMMON_FLAG_FAIL: //发放失败
                this.serviceShowStatus = EquityConstants.BATCH_DISTRIBUTION_APPLY_STATUS_IN_PROCESS; //发放中
                this.issuingBodyShowStatus = EquityConstants.BATCH_DISTRIBUTION_APPLY_STATUS_IN_PROCESS; //发放中
                break;
            default:
                this.serviceShowStatus = status;
                this.issuingBodyShowStatus = status;
                break;
        }
        return this;
    }

    public String getInsuranceCompanyRebateOverstepLabel() {
        if (StringUtils.isNotBlank(insuranceCompanyRebateOverstep)) {
            return "Y".equals(insuranceCompanyRebateOverstep) ? "是" : "否";
        }
        return insuranceCompanyRebateOverstep;
    }

    public String getGrantRealPaymentMobileFlagLabel() {
        if (StringUtils.isNotBlank(grantRealPaymentMobileFlag)) {
            return "Y".equals(grantRealPaymentMobileFlag) ? "是" : "否";
        }
        return grantRealPaymentMobileFlag;
    }

    public String getThisOrderRefundFlagLabel() {
        if (StringUtils.isNotBlank(thisOrderRefundFlag)) {
            return "Y".equals(thisOrderRefundFlag) ? "是" : "否";
        }
        return thisOrderRefundFlag;
    }


    /**
     * 新发券 是否能撤回
     * @return
     */
    public boolean recallable() {

        List<String> recallableStatusList = Lists.newArrayList(EquityConstants.DictApplyDetailWorkFlowStatus.PENDING_AUDIT, EquityConstants.DictApplyDetailWorkFlowStatus.PENDING_APPROVE);

        //是否是允许撤回状态条件
        boolean allowRecallCondition =
                (COMMON_FLAG_N.equals(workFlowEndFlag) && recallableStatusList.contains(workFlowStatus))
                 || ( COMMON_FLAG_Y.equals(workFlowEndFlag) && COMMON_FLAG_APPROVE.equals(status));

       return allowRecallCondition;

    }
}
