package com.rocogz.syy.equity.entity.issuingBody;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.dto.issuingBody.EquityIssuingBodyAssociatedDto;
import com.rocogz.syy.equity.dto.issuingBody.IssuingBodyRoleDto;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 主体工作流节点配置表
 * </p>
 *
 * @author 陈煜敏
 * @since 2022-12-16
 */
@TableName(value = "equity_issuing_body_node_base_config")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
public class IssuingBodyNodeBaseConfig extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 节点编号
     */
    private String nodeCode;

    /**
     * 节点名称
     */
    private String nodeName;

    /**
     * 节点序号
     */
    private String nodeSeq;

    /**
     * 节点类型, APPROVE-审批，AUDIT-审核
     */
    private String nodeType;

    /**
     * 主体编号
     */
    private String issuingBodyCode;

    /**
     * 规则编号
     */
    private String ruleCode;

    /**
     * 明细列表
     */
    @TableField(exist = false)
    private List<IssuingBodyNodeBaseDetail> detailList;

    /**
     * 下一节点
     */
    @TableField(exist = false)
    private IssuingBodyNodeBaseConfig next;

}
