package com.rocogz.syy.equity.entity.issuingBody;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 主体工作流规则配置表
 * </p>
 * @author 陈煜敏
 * @since 2023-08-03
 */
@TableName(value = "equity_issuing_body_rule_config")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
public class IssuingBodyRuleConfig extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 规则编号
     */
    private String code;

    /**
     * 主体编号
     */
    private String issuingBodyCode;

    /**
     * 状态：LOCK(停用),OPEN(启用)
     */
    private String status;

    /**
     * 规则节点列表
     */
    @TableField(exist = false)
    private List<IssuingBodyRuleConfigNode> nodeList;

    /**
     * 审批节点数量
     */
    @TableField(exist = false)
    private int workflowNodeCount;

    /**
     * 登记人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

}
