package com.rocogz.syy.equity.entity.issuingBodyProjectCost;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 主体项目赠送成本统计 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2023-08-09 09:10:42</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_issuing_body_project_give_cost_stat")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityIssuingBodyProjectGiveCostStat extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 主体编号
     */
    private String issuingBodyCode;

    /**
     * 主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 业务类型
     */
    private String businessTypeCode;

    /**
     * 业务类型名称
     */
    @TableField(exist = false)
    private String businessTypeName;

    /**
     * 产品类别
     */
    private String productType;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 红线本金
     */
    private BigDecimal redLineAmount;

    /**
     * 保司政策金额合计
     */
    private BigDecimal insurancePolicyTotalAmount;

    /**
     * 成本合计
     */
    private BigDecimal totalCostAmount;

    /**
     * 保单年度
     */
    private String policyYear;

    /**
     * 续保员
     */
    private String renewalInsurePerson;

    /**
     * 发放月份
     */
    private String grantMonth;

    /**
     * 发放日期
     */
    private LocalDate grantDate;

    /**
     * 现金赠送盈余金额
     */
    @TableField(exist = false)
    private BigDecimal cashGiveSurplusAmount;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建人手机号
     */
    private String createUserMobile;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新人手机号
     */
    private String updateUserMobile;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
