package com.rocogz.syy.equity.entity.rule;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "equity_inssuing_gift_rule")
public class EquityInssuingGiftRule extends UserTimeEntity {
    private static final long serialVersionUID=1L;

    /**
     * 规则编号
     */
    private String giftRuleCode;

    /**
     * 成本统计对象
     */
    private String ruleObjects;

    /**
     * 成本统计对象
     */
    private String ruleObjectsName;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 项目赠送成本红线金额
     */
    private BigDecimal costRedLineAmount;

    /**
     *
     状态 启用OPEN,  停用LOCK
     */
    private String giftRuleStatus;

    /**
     *是否全部业务类型
     */
    private Boolean isAll = false;

    /**
     * 业务类型
     */
    @TableField(exist = false)
    private List<GiftRuleBusinessType> businessTypeList;

    /**
     * 业务类型
     */
    @TableField(exist = false)
    private List<String> businessCodeList;

    @TableField(exist = false)
    private String businessNames;
}
