/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.equity;

import com.rocogz.syy.equity.dto.issuingBody.IssuingBodyRuleQueryDto;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionApplyLimitConfigNode;
import com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail;
import com.rocogz.util.DateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class EquityCommonUtil {
    public static LocalDateTime getEffectiveInvalidDateByMode(String model, String modeVal, String type, LocalDate pointDate) {
        LocalDateTime localDateTime = null;
        if ("NOW".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(LocalDate.now().toString() + " 00:00:00"));
        } else if ("POINT_DATE".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(modeVal + ("E".equals(type) ? " 00:00:00" : " 23:59:59")));
        } else if ("LAST_DAY".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(LocalDate.now().plusDays(Long.valueOf(modeVal)) + ("E".equals(type) ? " 00:00:00" : " 23:59:59")));
        } else if ("POLICY_DATE".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(pointDate.plusDays(Long.valueOf(modeVal)) + ("E".equals(type) ? " 00:00:00" : " 23:59:59")));
        }
        return localDateTime;
    }

    public static LocalDateTime getOrderInvalidDate(String orderInvalidModel, String orderInvalidValue, LocalDateTime userCouponInvalidDate) {
        if ("COUPON_LAST_DAY_INVALID".equals(orderInvalidModel)) {
            return userCouponInvalidDate.plusDays(Long.valueOf(orderInvalidValue));
        }
        return userCouponInvalidDate;
    }

    public static String convertTimeInRegion(Integer hour) {
        if (hour >= 0 && hour < 12) {
            return "AM";
        }
        if (hour >= 12 && hour < 18) {
            return "PM";
        }
        return "NIGHT";
    }

    private static String beforeSplit(String param, String value) {
        if (param.length() <= Integer.parseInt(value)) {
            return param;
        }
        return param.substring(0, Integer.parseInt(value));
    }

    private static String afterSplit(String param, String value) {
        if (param.length() <= Integer.parseInt(value)) {
            return param;
        }
        return param.substring(param.length() - Integer.parseInt(value), param.length());
    }

    public static String generateRuleSigna(Map<String, String> ruleMap, String name, String mobile, String licenseNo, String idCard) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (Map.Entry<String, String> entry : ruleMap.entrySet()) {
            if ("NAME".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)name)) {
                multiValueMap.add((Object)entry.getKey(), (Object)("Y".equals(entry.getValue()) ? name : ""));
            }
            if ("MOBILE_BEFORE_N".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)mobile)) {
                multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.beforeSplit(mobile, entry.getValue()));
            }
            if ("MOBILE_AFTER_N".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)mobile)) {
                multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.afterSplit(mobile, entry.getValue()));
            }
            if ("CARNUMBER_AFTER_N".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)licenseNo)) {
                multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.afterSplit(licenseNo, entry.getValue()));
            }
            if (!"IDCARD_AFTER_N".equals(entry.getKey()) || !StringUtils.isNotBlank((CharSequence)idCard)) continue;
            multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.afterSplit(idCard, entry.getValue()));
        }
        return EquityCommonUtil.signatureStr((MultiValueMap<String, String>)multiValueMap);
    }

    public static String generateRuleSigna(String name, String mobile, String licenseNo, String idCard) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"MOBILE_BEFORE_N", (Object)EquityCommonUtil.beforeSplit(mobile, "3"));
        multiValueMap.add((Object)"MOBILE_AFTER_N", (Object)EquityCommonUtil.afterSplit(mobile, "4"));
        multiValueMap.add((Object)"CARNUMBER_AFTER_N", (Object)EquityCommonUtil.afterSplit(licenseNo, "3"));
        multiValueMap.add((Object)"NAME", (Object)name);
        if (StringUtils.isNotBlank((CharSequence)idCard)) {
            multiValueMap.add((Object)"IDCARD_AFTER_N", (Object)EquityCommonUtil.afterSplit(idCard, "6"));
        }
        return EquityCommonUtil.signatureStr((MultiValueMap<String, String>)multiValueMap);
    }

    private static String signatureStr(MultiValueMap<String, String> parameters) {
        StringBuilder tempStr = new StringBuilder();
        TreeSet values = new TreeSet();
        for (String key : parameters.keySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)((List)parameters.get((Object)key)).get(0)))) continue;
            values.add(((List)parameters.get((Object)key)).get(0));
        }
        for (String val : values) {
            tempStr.append(val);
        }
        return tempStr.toString();
    }

    public static Map<String, String> batchDetailSearchSql(List<String> conditionList, EquityBatchDistributionApplyLimitConfigNode ruleNode, EquityBatchDistributionCouponApplyDetail detailEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer key = new StringBuffer();
        if (!"*".equals(ruleNode.getBusinessType())) {
            sql.append(" AND detail.issuing_body_business_type='").append(detailEntity.getIssuingBodyBusinessType()).append("'");
            key.append(detailEntity.getIssuingBodyBusinessType());
        }
        if (!"*".equals(ruleNode.getCustomerType())) {
            sql.append(" AND detail.business_customer_type='").append(detailEntity.getBusinessCustomerType()).append("'");
            key.append(detailEntity.getBusinessCustomerType());
        }
        if (!"*".equals(ruleNode.getProductType())) {
            sql.append(" AND detail.coupon_type_code='").append(detailEntity.getCouponTypeCode()).append("'");
            key.append(detailEntity.getCouponTypeCode());
        }
        if (CollectionUtils.isNotEmpty(conditionList)) {
            String licenseNo;
            if (conditionList.contains("MOBILE")) {
                if (StringUtils.isNotBlank((CharSequence)detailEntity.getMobile())) {
                    sql.append(" AND detail.mobile='").append(detailEntity.getMobile()).append("'");
                } else {
                    sql.append(" AND detail.mobile is null");
                }
                key.append(detailEntity.getMobile());
            }
            if (conditionList.contains("NAME")) {
                if (StringUtils.isNotBlank((CharSequence)detailEntity.getName())) {
                    sql.append(" AND detail.name='").append(detailEntity.getName()).append("'");
                } else {
                    sql.append(" AND detail.name is null");
                }
                key.append(detailEntity.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)(licenseNo = detailEntity.getLicenseNo()))) {
                if (conditionList.contains("LICENSE_NO_AFTER_THREE")) {
                    String tmplicenseNo = licenseNo.length() > 3 ? licenseNo.substring(licenseNo.length() - 3, licenseNo.length()) : licenseNo;
                    sql.append(" AND detail.license_no like '%").append(tmplicenseNo).append("'");
                    key.append(tmplicenseNo);
                }
                if (conditionList.contains("FULL_LICENSE_NO")) {
                    sql.append(" AND detail.license_no='").append(licenseNo).append("'");
                    key.append(licenseNo);
                }
            } else if (conditionList.contains("LICENSE_NO_AFTER_THREE") || conditionList.contains("FULL_LICENSE_NO")) {
                sql.append(" AND detail.license_no is null");
            }
            if (conditionList.contains("VIN_NO")) {
                if (StringUtils.isNotBlank((CharSequence)detailEntity.getVinNo())) {
                    sql.append(" AND detail.vin_no='").append(detailEntity.getVinNo()).append("'");
                } else {
                    sql.append(" AND detail.vin_no is null");
                }
                key.append(detailEntity.getVinNo());
            }
            map.put("searchSql", sql.toString());
            map.put("paramKey", key.toString());
        }
        return map;
    }

    public static String pointUseRuleSql(String useRuleCode, String idCardExplicit, String name, String mobile, boolean isWithdrawals) {
        String searchSql = "";
        if (isWithdrawals) {
            if (StringUtils.isNotBlank((CharSequence)useRuleCode)) {
                String[] ruleCodeStr = useRuleCode.split("\\|");
                searchSql = searchSql + " AND point.use_rule_code='" + useRuleCode + "'";
                block10: for (int i = 0; i < ruleCodeStr.length; ++i) {
                    switch (ruleCodeStr[i]) {
                        case "NAME": {
                            searchSql = searchSql + " AND point.user_name='" + (StringUtils.isNotBlank((CharSequence)name) ? name : "") + "'";
                            continue block10;
                        }
                        case "PHONENUMBER": {
                            searchSql = searchSql + " AND point.mobile='" + (StringUtils.isNotBlank((CharSequence)mobile) ? mobile : "") + "'";
                            continue block10;
                        }
                        case "CARNUMBER": {
                            searchSql = searchSql + " AND point.id_card_explicit='" + (StringUtils.isNotBlank((CharSequence)idCardExplicit) ? idCardExplicit : "") + "'";
                            continue block10;
                        }
                    }
                }
            } else {
                searchSql = " AND point.use_rule_code is null ";
            }
        }
        return searchSql;
    }

    public static String convertNowDateToYear(LocalDate nowDate) {
        return String.valueOf(nowDate.getYear());
    }

    public static String convertCreatTimeToYear(LocalDateTime createTime) {
        return createTime.toString().substring(0, 4);
    }

    public static BigDecimal computeBusinessInsuranceRate(BigDecimal amount, BigDecimal businessInsurancePremium) {
        return Objects.nonNull(businessInsurancePremium) && businessInsurancePremium.compareTo(BigDecimal.ZERO) == 1 ? amount.divide(businessInsurancePremium, 4, RoundingMode.HALF_UP) : null;
    }

    public static String convertNodeTypeToStatus(String nodeType) {
        return "APPROVE".equals(nodeType) ? "PENDING_APPROVE" : "PENDING_AUDIT";
    }

    public static String convertPushCreateUserWxMsgKeyWord2(String name, String licenseNo) {
        name = StringUtils.isNotBlank((CharSequence)name) ? name : "";
        String string = licenseNo = StringUtils.isNotBlank((CharSequence)licenseNo) ? licenseNo : "";
        String tmpContent = StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)licenseNo) ? "" : (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)licenseNo) ? name + "/" + licenseNo : (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)licenseNo) ? name : licenseNo));
        return tmpContent;
    }

    public static String generateIssuingBodyRuleMatchKey(IssuingBodyRuleQueryDto dto) {
        if (dto == null) {
            return null;
        }
        return EquityCommonUtil.generateWorkFlowNodeKey(dto.getBusinessType(), dto.getCustomerType(), dto.getProductType(), dto.getProductCode());
    }

    public static String generateWorkFlowNodeKey(String ... param) {
        StringBuffer sb = new StringBuffer();
        for (String s : param) {
            sb.append(s).append("_");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public static EquityBatchDistributionCouponApplyDetail detailColumnDesensitive(EquityBatchDistributionCouponApplyDetail detail) {
        int i;
        if (StringUtils.isNotBlank((CharSequence)detail.getMobile())) {
            char[] mobileChars = detail.getMobile().toCharArray();
            for (i = 3; i < 7 && i < mobileChars.length; ++i) {
                mobileChars[i] = 42;
            }
            detail.setMobile(new String(mobileChars));
        }
        if (StringUtils.isNotBlank((CharSequence)detail.getName())) {
            char[] nameChars = detail.getName().toCharArray();
            for (i = 1; i < detail.getName().length() && i < nameChars.length; ++i) {
                nameChars[i] = 42;
            }
            detail.setName(new String(nameChars));
        }
        if (StringUtils.isNotBlank((CharSequence)detail.getLicenseNo())) {
            char[] licenseNoChar = detail.getLicenseNo().toCharArray();
            for (i = 0; i < 3 && i < licenseNoChar.length; ++i) {
                licenseNoChar[i] = 42;
            }
            detail.setLicenseNo(new String(licenseNoChar));
        }
        if (StringUtils.isNotBlank((CharSequence)detail.getVinNo())) {
            int start = 0;
            int end = 0;
            String vinNo = detail.getVinNo();
            if (vinNo.length() == 1) {
                end = 1;
            } else if (vinNo.length() > 1 && vinNo.length() <= 3) {
                start = 1;
                end = vinNo.length();
            } else if (vinNo.length() > 3 && vinNo.length() < 6 || vinNo.length() == 6) {
                end = 3;
            } else if (vinNo.length() > 6) {
                end = vinNo.length() - 6;
            }
            char[] vinNoChars = detail.getVinNo().toCharArray();
            for (int i2 = start; i2 < end && i2 < vinNoChars.length; ++i2) {
                vinNoChars[i2] = 42;
            }
            detail.setVinNo(new String(vinNoChars));
        }
        return detail;
    }
}

