/*
Navicat MySQL Data Transfer

Source Server         : picc-0918
Source Server Version : 50631
Source Host           : 192.168.3.102:3306
Source Database       : picccar_audit

Target Server Type    : MYSQL
Target Server Version : 50631
File Encoding         : 65001

Date: 2018-09-19 10:41:38
*/

SET FOREIGN_KEY_CHECKS=0;


-- seata 1.1
-- for AT mode you must to init this sql for you business database. the seata server not need it.
CREATE TABLE IF NOT EXISTS `undo_log`
(
    `id`            BIGINT(20)   NOT NULL AUTO_INCREMENT COMMENT 'increment id',
    `branch_id`     BIGINT(20)   NOT NULL COMMENT 'branch transaction id',
    `xid`           VARCHAR(100) NOT NULL COMMENT 'global transaction id',
    `context`       VARCHAR(128) NOT NULL COMMENT 'undo_log context,such as serialization',
    `rollback_info` LONGBLOB     NOT NULL COMMENT 'rollback info',
    `log_status`    INT(11)      NOT NULL COMMENT '0:normal status,1:defense status',
    `log_created`   DATETIME     NOT NULL COMMENT 'create datetime',
    `log_modified`  DATETIME     NOT NULL COMMENT 'modify datetime',
    PRIMARY KEY (`id`),
    UNIQUE KEY `ux_undo_log` (`xid`, `branch_id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  DEFAULT CHARSET = utf8 COMMENT ='AT transaction mode undo table';

-- -------------------------------- The script used when storeMode is 'db' --------------------------------
-- the table to store GlobalSession data
CREATE TABLE IF NOT EXISTS `global_table`
(
    `xid`                       VARCHAR(128) NOT NULL,
    `transaction_id`            BIGINT,
    `status`                    TINYINT      NOT NULL,
    `application_id`            VARCHAR(32),
    `transaction_service_group` VARCHAR(32),
    `transaction_name`          VARCHAR(128),
    `timeout`                   INT,
    `begin_time`                BIGINT,
    `application_data`          VARCHAR(2000),
    `gmt_create`                DATETIME,
    `gmt_modified`              DATETIME,
    PRIMARY KEY (`xid`),
    KEY `idx_gmt_modified_status` (`gmt_modified`, `status`),
    KEY `idx_transaction_id` (`transaction_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

-- the table to store BranchSession data
CREATE TABLE IF NOT EXISTS `branch_table`
(
    `branch_id`         BIGINT       NOT NULL,
    `xid`               VARCHAR(128) NOT NULL,
    `transaction_id`    BIGINT,
    `resource_group_id` VARCHAR(32),
    `resource_id`       VARCHAR(256),
    `branch_type`       VARCHAR(8),
    `status`            TINYINT,
    `client_id`         VARCHAR(64),
    `application_data`  VARCHAR(2000),
    `gmt_create`        DATETIME(6),
    `gmt_modified`      DATETIME(6),
    PRIMARY KEY (`branch_id`),
    KEY `idx_xid` (`xid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

-- the table to store lock data
CREATE TABLE IF NOT EXISTS `lock_table`
(
    `row_key`        VARCHAR(128) NOT NULL,
    `xid`            VARCHAR(96),
    `transaction_id` BIGINT,
    `branch_id`      BIGINT       NOT NULL,
    `resource_id`    VARCHAR(256),
    `table_name`     VARCHAR(100),
    `pk`             VARCHAR(36),
    `gmt_create`     DATETIME,
    `gmt_modified`   DATETIME,
    PRIMARY KEY (`row_key`),
    KEY `idx_branch_id` (`branch_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;



-- ----------------------------
-- Table structure for menu
-- ----------------------------
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(30) COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(30) COLLATE utf8mb4_bin NOT NULL,
  `href` varchar(70) COLLATE utf8mb4_bin NOT NULL,
  `spread` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(30) COLLATE utf8mb4_bin NOT NULL,
  `pid` int(11) NOT NULL,
  `seq` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO `menu` VALUES ('1', 'sy', '首页', 'page/main.html', '0', 'icon-computer', '0', '2', '1', 'OPEN');
INSERT INTO `menu` VALUES ('2', 'xtgl', '系统管理', '', '0', '&#xe630;', '0', '1', '1', 'OPEN');
INSERT INTO `menu` VALUES ('6', 'gylgl', '管理员管理', 'page/system/admin/admin.html', '0', '&#xe630;', '2', '1', '2', 'OPEN');
INSERT INTO `menu` VALUES ('7', 'jsgl', '角色管理', 'page/system/role/role.html', '0', '&#xe61c;', '2', '2', '2', 'OPEN');
INSERT INTO `menu` VALUES ('17', 'cdgl', '菜单管理', 'page/system/menu/menu.html', '0', '&#xe61c;', '2', '5', '2', 'OPEN');
INSERT INTO `menu` VALUES ('18', 'zdbgl', '字典表管理', 'page/system/dict/type/type.html', '0', '&#xe61c;', '2', '6', '2', 'OPEN');

-- ----------------------------
-- Table structure for system_admin_user
-- ----------------------------
DROP TABLE IF EXISTS `system_admin_user`;
CREATE TABLE `system_admin_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL COMMENT '用户名',
  `job_no` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL COMMENT '密码',
  `salt` varchar(20) NOT NULL COMMENT '盐值',
  `name` varchar(20) NOT NULL COMMENT '真实姓名',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '逻辑删除标志位',
  `status` enum('LOCK','OPEN') NOT NULL COMMENT '管理员状态',
  `keyword` varchar(255) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_user` int(11) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime DEFAULT NULL COMMENT '最后更新时间',
  `update_user` int(11) DEFAULT NULL COMMENT '最后更新人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8 COMMENT='管理员账号表';

-- ----------------------------
-- Records of system_admin_user
-- ----------------------------
INSERT INTO `system_admin_user` VALUES ('1', 'admin', 'gdrb001', '88dceffdc3386d2da42c1b4082d7ecb9b0e2e265', '98a7188e776e8ddd', '超级管理员', '18600687653', 'losemycat@gmail.com', '0', 'OPEN', null, '2017-07-19 16:07:12', '1', null, null);
INSERT INTO `system_admin_user` VALUES ('82', 'zjkTest', '000388', 'fee11e89378169195f69718b1bca7c2e94915f34', 'f7eabded95be985f', '张俊奎', '17718483110', 'zhangjunkui@rocoinfo.com', '0', 'OPEN', '张俊奎,17718483110,zjkTest,000388,zjk,zjkTest', '2018-09-19 10:01:26', '1', null, null);

-- ----------------------------
-- Table structure for system_permission
-- ----------------------------
DROP TABLE IF EXISTS `system_permission`;
CREATE TABLE `system_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '权限名称',
  `module` varchar(255) DEFAULT NULL COMMENT '模块名称',
  `seq` int(11) NOT NULL COMMENT '排序字段',
  `menu_id` int(11) DEFAULT NULL,
  `view_permission` varchar(255) DEFAULT NULL COMMENT '页面权限',
  `url_permission` varchar(255) DEFAULT NULL COMMENT 'url权限',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of system_permission
-- ----------------------------
INSERT INTO `system_permission` VALUES ('1', '所有权限', 'embed', '0', '0', '*', '*');
INSERT INTO `system_permission` VALUES ('219', '新增管理员', '管理员管理', '1', '6', 'system:user:create', null);
INSERT INTO `system_permission` VALUES ('220', '编辑管理员', '管理员管理', '2', '6', 'system:user:edit', null);
INSERT INTO `system_permission` VALUES ('221', '启/停用管理员', '管理员管理', '3', '6', 'system:user:status', null);
INSERT INTO `system_permission` VALUES ('222', '删除管理员', '管理员管理', '4', '6', 'system:user:del', null);
INSERT INTO `system_permission` VALUES ('223', '重置密码', '管理员管理', '5', '6', 'system:user:resetpwd', null);
INSERT INTO `system_permission` VALUES ('224', '设置角色', '管理员管理', '6', '6', 'system:user:setrole', null);
INSERT INTO `system_permission` VALUES ('225', '新增角色', '角色管理', '1', '7', 'system:role:create', null);
INSERT INTO `system_permission` VALUES ('226', '编辑角色', '角色管理', '2', '7', 'system:role:edit', null);
INSERT INTO `system_permission` VALUES ('227', '删除角色', '角色管理', '3', '7', 'system:role:del', null);
INSERT INTO `system_permission` VALUES ('228', '角色授权', '角色管理', '4', '7', 'system:role:setpermission', null);
INSERT INTO `system_permission` VALUES ('248', '新增子菜单', '菜单管理', '1', '17', 'system:menu:create', null);
INSERT INTO `system_permission` VALUES ('249', '编辑子菜单', '菜单管理', '2', '17', 'system:menu:edit', null);
INSERT INTO `system_permission` VALUES ('250', '启/停用子菜单', '菜单管理', '3', '17', 'system:menu:status', null);

-- ----------------------------
-- Table structure for system_role
-- ----------------------------
DROP TABLE IF EXISTS `system_role`;
CREATE TABLE `system_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL COMMENT '角色名称',
  `description` varchar(20) NOT NULL COMMENT '角色描述',
  `deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标志位',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_user` int(11) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime DEFAULT NULL COMMENT '最后更新时间',
  `update_user` int(11) DEFAULT NULL COMMENT '最后更新人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of system_role
-- ----------------------------
INSERT INTO `system_role` VALUES ('1', '超级管理员', '超级管理员', '0', null, null, null, null);
INSERT INTO `system_role` VALUES ('51', 'zjkTest', '张俊奎测试', '0', '2018-09-19 10:01:47', '1', null, null);

-- ----------------------------
-- Table structure for system_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `system_role_menu`;
CREATE TABLE `system_role_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=567 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of system_role_menu
-- ----------------------------
INSERT INTO `system_role_menu` VALUES ('1', '1', '1');
INSERT INTO `system_role_menu` VALUES ('2', '1', '2');
INSERT INTO `system_role_menu` VALUES ('3', '1', '3');
INSERT INTO `system_role_menu` VALUES ('4', '1', '4');
INSERT INTO `system_role_menu` VALUES ('5', '1', '5');
INSERT INTO `system_role_menu` VALUES ('6', '1', '6');
INSERT INTO `system_role_menu` VALUES ('7', '1', '7');
INSERT INTO `system_role_menu` VALUES ('8', '1', '8');
INSERT INTO `system_role_menu` VALUES ('9', '1', '9');
INSERT INTO `system_role_menu` VALUES ('10', '1', '10');
INSERT INTO `system_role_menu` VALUES ('11', '1', '11');
INSERT INTO `system_role_menu` VALUES ('12', '1', '12');
INSERT INTO `system_role_menu` VALUES ('13', '1', '13');
INSERT INTO `system_role_menu` VALUES ('14', '1', '14');
INSERT INTO `system_role_menu` VALUES ('15', '1', '15');
INSERT INTO `system_role_menu` VALUES ('17', '1', '16');
INSERT INTO `system_role_menu` VALUES ('18', '1', '17');
INSERT INTO `system_role_menu` VALUES ('36', '1', '21');
INSERT INTO `system_role_menu` VALUES ('37', '1', '22');
INSERT INTO `system_role_menu` VALUES ('54', '1', '23');
INSERT INTO `system_role_menu` VALUES ('80', '1', '24');
INSERT INTO `system_role_menu` VALUES ('81', '1', '25');
INSERT INTO `system_role_menu` VALUES ('82', '1', '26');
INSERT INTO `system_role_menu` VALUES ('83', '1', '27');
INSERT INTO `system_role_menu` VALUES ('84', '1', '29');
INSERT INTO `system_role_menu` VALUES ('382', '1', '32');
INSERT INTO `system_role_menu` VALUES ('383', '1', '33');
INSERT INTO `system_role_menu` VALUES ('384', '1', '34');
INSERT INTO `system_role_menu` VALUES ('385', '1', '35');
INSERT INTO `system_role_menu` VALUES ('386', '1', '36');
INSERT INTO `system_role_menu` VALUES ('387', '1', '37');
INSERT INTO `system_role_menu` VALUES ('388', '1', '38');
INSERT INTO `system_role_menu` VALUES ('389', '1', '39');
INSERT INTO `system_role_menu` VALUES ('390', '1', '40');
INSERT INTO `system_role_menu` VALUES ('391', '1', '41');
INSERT INTO `system_role_menu` VALUES ('392', '1', '42');
INSERT INTO `system_role_menu` VALUES ('393', '1', '43');
INSERT INTO `system_role_menu` VALUES ('394', '1', '44');
INSERT INTO `system_role_menu` VALUES ('395', '1', '45');
INSERT INTO `system_role_menu` VALUES ('396', '1', '46');
INSERT INTO `system_role_menu` VALUES ('397', '1', '47');
INSERT INTO `system_role_menu` VALUES ('398', '1', '48');
INSERT INTO `system_role_menu` VALUES ('399', '1', '49');
INSERT INTO `system_role_menu` VALUES ('400', '1', '50');
INSERT INTO `system_role_menu` VALUES ('401', '1', '51');
INSERT INTO `system_role_menu` VALUES ('402', '1', '52');
INSERT INTO `system_role_menu` VALUES ('454', '1', '105');
INSERT INTO `system_role_menu` VALUES ('455', '1', '106');
INSERT INTO `system_role_menu` VALUES ('564', '1', '107');
INSERT INTO `system_role_menu` VALUES ('565', '1', '108');
INSERT INTO `system_role_menu` VALUES ('566', '1', '109');

-- ----------------------------
-- Table structure for system_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `system_role_permission`;
CREATE TABLE `system_role_permission` (
  `role_id` int(11) NOT NULL COMMENT '角色id',
  `permission_id` int(11) NOT NULL COMMENT '权限id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of system_role_permission
-- ----------------------------
INSERT INTO `system_role_permission` VALUES ('1', '1');

-- ----------------------------
-- Table structure for system_user_role
-- ----------------------------
DROP TABLE IF EXISTS `system_user_role`;
CREATE TABLE `system_user_role` (
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `role_id` int(11) NOT NULL COMMENT '角色id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of system_user_role
-- ----------------------------
INSERT INTO `system_user_role` VALUES ('1', '1');

-- ----------------------------
-- Table structure for dict_data
-- ----------------------------
DROP TABLE IF EXISTS `dict_data`;
CREATE TABLE `dict_data`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '类型编码',
  `p_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `code` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '显示名称',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '配置描述',
  `data_sort` int(11) NOT NULL COMMENT '排序值',
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '状态',
  `create_user` int(10) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `update_user` int(10) NULL DEFAULT NULL,
  `update_time` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_type_code`(`type_code`) USING BTREE COMMENT '数据字典类型编码'
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for dict_type
-- ----------------------------
DROP TABLE IF EXISTS `dict_type`;
CREATE TABLE `dict_type`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '编码',
  `name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '名称',
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '状态',
  `create_user` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `create_time` datetime(0) NOT NULL,
  `update_user` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `update_time` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE,
  INDEX `idx_name`(`name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = Compact;
