/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.system.adminuser.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.rocogz.syy.business.system.adminuser.mapper.SystemAdminUserMapper;
import com.rocogz.syy.business.system.adminuser.service.ISystemAdminUserService;
import com.rocogz.syy.business.system.menu.mapper.SystemRoleMenuMapper;
import com.rocogz.syy.business.system.role.mapper.SystemRoleMapper;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import com.rocogz.syy.infrastructure.entity.menu.Menu;
import com.rocogz.syy.infrastructure.enumerate.IsEnum;
import com.rocogz.syy.infrastructure.enumerate.StatusEnum;
import com.rocogz.syy.util.BuildTreeUtil;
import com.rocogz.util.PasswordUtil;
import com.rocogz.util.PingYinUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemAdminUserServiceImpl
extends ServiceImpl<SystemAdminUserMapper, AdminUser>
implements ISystemAdminUserService {
    private final String DEFAULT_PASSWORD = "e10adc3949ba59abbe56e057f20f883e";
    @Autowired
    private SystemRoleMapper roleDao;
    @Autowired
    private SystemRoleMenuMapper menuDao;

    @Override
    public List<Menu> findMenuByAdminUserId(Long adminUserId) {
        if (adminUserId == null) {
            return Lists.newArrayList();
        }
        List<Long> roleIds = ((SystemAdminUserMapper)this.baseMapper).findRoleIdsByAdminUserId(adminUserId);
        List<Long> menuIds = this.roleDao.findMenuIdsByRoleIds(roleIds);
        List<Menu> menus = this.menuDao.findMenusByMenuIds(menuIds);
        return BuildTreeUtil.buildMenuList(menus, 0);
    }

    @Transactional(rollbackFor={Exception.class})
    public Response create(AdminUser user) {
        if (this.getByUsername(user.getUsername()) != null) {
            return Response.failure((String)"\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
        }
        if (this.getByUsername(user.getJobNo()) != null) {
            return Response.failure((String)("\u5de5\u53f7\u3010" + user.getJobNo() + "\u3011\u5df2\u88ab\u7528\u6237\u540d\u5360\u7528\uff01"));
        }
        if (this.getByJobNo(user.getJobNo()) != null) {
            return Response.failure((String)"\u5de5\u53f7\u5df2\u5b58\u5728\uff01");
        }
        if (this.getByJobNo(user.getUsername()) != null) {
            return Response.failure((String)("\u7528\u6237\u540d\u3010" + user.getUsername() + "\u3011\u5df2\u88ab\u5de5\u53f7\u5360\u7528\uff01"));
        }
        String salt = PasswordUtil.generateSalt();
        user.setSalt(salt);
        user.setPassword(PasswordUtil.entryptUserPassword((String)"e10adc3949ba59abbe56e057f20f883e", (String)salt));
        user.setStatus(StatusEnum.OPEN);
        user.setDeleted(Boolean.valueOf(false));
        user.setJobNo(user.getUsername());
        user.setUppass(IsEnum.N);
        String keyword = this.getKeyword(user);
        user.setKeyword(keyword);
        this.save(user);
        if (user.getRoleId() != null && user.getRoleId().size() > 0) {
            this.roleDao.insertUserRole(user.getId(), user.getRoleId());
        }
        return Response.succeed();
    }

    @Transactional(rollbackFor={Exception.class})
    public Response edit(AdminUser user) {
        AdminUser existUser = this.getByUsername(user.getUsername());
        if (existUser != null && !existUser.getId().equals(user.getId())) {
            return Response.failure((String)"\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
        }
        AdminUser existUserJobNo = this.getByJobNo(user.getUsername());
        if (existUserJobNo != null && !existUserJobNo.getId().equals(user.getId())) {
            return Response.failure((String)("\u7528\u6237\u540d\u3010" + user.getUsername() + "\u3011\u5df2\u88ab\u5de5\u53f7\u5360\u7528\uff01"));
        }
        AdminUser existJobNo = this.getByJobNo(user.getJobNo());
        if (existJobNo != null && !existJobNo.getId().equals(user.getId())) {
            return Response.failure((String)"\u5de5\u53f7\u5df2\u5b58\u5728\uff01");
        }
        AdminUser existJobNoUser = this.getByJobNo(user.getUsername());
        if (existJobNoUser != null && !existJobNoUser.getId().equals(user.getId())) {
            return Response.failure((String)("\u5de5\u53f7\u3010" + user.getJobNo() + "\u3011\u5df2\u88ab\u7528\u6237\u540d\u5360\u7528\uff01"));
        }
        user.setKeyword(this.getKeyword(user));
        ((SystemAdminUserMapper)this.baseMapper).updateById(user);
        this.roleDao.deleteUserRolesByUserId((long)user.getId());
        if (user.getRoleId() != null && user.getRoleId().size() > 0) {
            this.roleDao.insertUserRole(user.getId(), user.getRoleId());
        }
        return Response.succeed();
    }

    @Transactional(rollbackFor={Exception.class})
    public Response resetPwd(Integer id) {
        if (id == null || this.getById(id) == null) {
            return Response.failure((String)"\u7528\u6237id\u4e3anull\u6216\u67e5\u8be2\u4e0d\u5230\u6b64\u7528\u6237\u4fe1\u606f");
        }
        AdminUser user = new AdminUser(id);
        String salt = PasswordUtil.generateSalt();
        user.setSalt(salt);
        user.setPassword(PasswordUtil.entryptUserPassword((String)"e10adc3949ba59abbe56e057f20f883e", (String)salt));
        int i = ((SystemAdminUserMapper)this.baseMapper).updateById(user);
        if (i > 0) {
            return Response.succeed();
        }
        return Response.failure();
    }

    public Response modifyPwd(Integer id, String oldPwd, String newPwd) {
        AdminUser user = (AdminUser)((SystemAdminUserMapper)this.baseMapper).selectById(id);
        try {
            if (user.getPassword().equals(PasswordUtil.hashPassword((String)oldPwd, (String)user.getSalt()))) {
                AdminUser u = new AdminUser(id);
                String salt = PasswordUtil.generateSalt();
                u.setSalt(salt);
                u.setPassword(PasswordUtil.entryptUserPassword((String)newPwd, (String)salt));
                u.setUppass(IsEnum.Y);
                ((SystemAdminUserMapper)this.baseMapper).updateById(u);
                return Response.succeed((String)"\u4fee\u6539\u5bc6\u7801\u6210\u529f\uff01");
            }
            return Response.failure((String)"\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01");
        }
        catch (Exception e) {
            return Response.failure((String)"\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff01");
        }
    }

    public void batchOpen(List<Long> idList) {
        ((SystemAdminUserMapper)this.baseMapper).batchOpen(idList);
    }

    public void batchLock(List<Long> idList) {
        ((SystemAdminUserMapper)this.baseMapper).batchLock(idList);
    }

    @Override
    public List<AdminUser> searchScrollPage(IPage page, Map query) {
        return ((SystemAdminUserMapper)this.baseMapper).search(page, query);
    }

    public AdminUser getAllInfoById(Long id) {
        if (id != null) {
            return ((SystemAdminUserMapper)this.baseMapper).getAllInfoById(id);
        }
        return null;
    }

    public AdminUser getAllInfoByUsername(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            AdminUser user = ((SystemAdminUserMapper)this.baseMapper).getAllInfoByUsername(username);
            return user;
        }
        return null;
    }

    private AdminUser getByUsername(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            AdminUser user = ((SystemAdminUserMapper)this.baseMapper).getByUsername(username);
            return user;
        }
        return null;
    }

    private AdminUser getByJobNo(String jobNo) {
        if (StringUtils.isNotBlank((CharSequence)jobNo)) {
            AdminUser user = ((SystemAdminUserMapper)this.baseMapper).getByJobNo(jobNo);
            return user;
        }
        return null;
    }

    private String getKeyword(AdminUser user) {
        StringBuilder sb = new StringBuilder();
        sb.append(user.getName()).append(",").append(user.getMobile()).append(",").append(user.getUsername()).append(",").append(user.getJobNo()).append(",").append(PingYinUtil.getFirstSpell((String)user.getName())).append(",").append(PingYinUtil.getFirstSpell((String)user.getUsername()));
        return sb.toString();
    }

    @Transactional
    public Response activeUser(Integer id, String password) {
        try {
            AdminUser adminUser = new AdminUser(id);
            String salt = PasswordUtil.generateSalt();
            adminUser.setSalt(salt);
            adminUser.setPassword(PasswordUtil.entryptUserPassword((String)password, (String)salt));
            adminUser.setUppass(IsEnum.Y);
            ((SystemAdminUserMapper)this.baseMapper).updateById(adminUser);
            return Response.succeed((String)"\u4fee\u6539\u5bc6\u7801\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return Response.failure((String)"\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff01");
        }
    }
}

