/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.prefecture.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.rocogz.syy.business.prefecture.service.impl.PrefectureServiceImpl;
import com.rocogz.syy.common.controller.BaseController;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.tree.PrefectureTreeDto;
import com.rocogz.syy.infrastructure.entity.prefecture.Prefecture;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prefecture"})
public class PrefectureController
extends BaseController {
    @Autowired
    PrefectureServiceImpl prefectureServiceImpl;

    @GetMapping(value={"/getChild"})
    public Response<List<Prefecture>> getChild(@RequestParam(value="prefectureCode") String prefectureCode) {
        return this.prefectureServiceImpl.getChild(prefectureCode);
    }

    @GetMapping(value={"/pageQuery"})
    public Response<Page<Prefecture>> pageQuery(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) String name, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="limit", defaultValue="20") Integer limit) {
        Page pageQuery = new Page((long)page.intValue(), (long)limit.intValue());
        Page pageResult = (Page)this.prefectureServiceImpl.page((IPage)pageQuery, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)name), Prefecture::getName, (Object)name)).like(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)code), Prefecture::getCode, (Object)code));
        return Response.succeed((Object)pageResult);
    }

    @GetMapping(value={"/getTree"})
    public Response<List<PrefectureTreeDto>> getPrefectureTree() {
        return this.prefectureServiceImpl.getPrefectureTree();
    }

    @GetMapping(value={"/{id}"})
    public Response<Prefecture> getById(@PathVariable(value="id") Integer id) {
        return Response.succeed((Object)this.prefectureServiceImpl.getById((Serializable)id));
    }

    @GetMapping(value={"/getByCode"})
    public Response<Prefecture> getByCode(@RequestParam(value="code") String code) {
        return Response.succeed((Object)this.prefectureServiceImpl.getOne((Wrapper)Wrappers.lambdaQuery().eq(Prefecture::getCode, (Object)code)));
    }

    @PostMapping
    public Response saveOrUpdate(@RequestBody Prefecture prefecture) {
        if (this.prefectureServiceImpl.customSaveOrUpdate(prefecture)) {
            return Response.succeed((String)"\u66f4\u65b0\u6210\u529f!");
        }
        return Response.failure((String)"\u66f4\u65b0\u5931\u8d25!");
    }

    @GetMapping(value={"/findPrefectureList"})
    public Response<List<Prefecture>> findPrefectureList() {
        return this.prefectureServiceImpl.findPrefectureList();
    }

    @GetMapping(value={"/findPrefectureByCode"})
    Response<List<Prefecture>> findPrefectureByCode(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) String name, @RequestParam(value="prefectureCodeList") List<String> prefectureCodeList) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)code)) {
            params.put("code", StringUtils.wrap((String)name, (String)"%"));
        }
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)name)) {
            params.put("name", StringUtils.wrap((String)name, (String)"%"));
        }
        return this.prefectureServiceImpl.findPrefectureByCode(params, prefectureCodeList);
    }
}

