/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.system.dict.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.rocogz.syy.business.system.dict.mapper.DictDataMapper;
import com.rocogz.syy.business.system.dict.service.IDictDataService;
import com.rocogz.syy.infrastructure.entity.dict.DictData;
import com.rocogz.syy.infrastructure.enumerate.StatusEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictDataServiceImpl
extends ServiceImpl<DictDataMapper, DictData>
implements IDictDataService {
    private static final Logger log = LoggerFactory.getLogger(DictDataServiceImpl.class);
    @Autowired
    private DictDataMapper dictdataMapper;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<DictData> getDictByTypeCode(String typeCode) {
        return this.dictdataMapper.getDictByTypeCode(typeCode);
    }

    public List<DictData> search(Map<String, Object> params) {
        return this.dictdataMapper.search(params);
    }

    public int updateStatusById(Long id, StatusEnum status) {
        return this.dictdataMapper.updateStatusById(id, status);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchEdit(List<DictData> dictDatas) {
        ArrayList<DictData> list;
        String error = this.validDictDatas(dictDatas);
        if (StringUtils.isEmpty((CharSequence)error)) {
            list = new ArrayList<DictData>();
            String typeCode = dictDatas.get(0).getTypeCode();
            for (DictData data : dictDatas) {
                if (data.getId() == null) {
                    data.setCreateTime(LocalDateTime.now());
                    this.dictdataMapper.insert(data);
                } else {
                    data.setUpdateTime(LocalDateTime.now());
                    this.dictdataMapper.update(data);
                }
                list.add(data);
            }
        } else {
            throw new RuntimeException(error);
        }
        this.logger.info("dictdata update:{}", list);
    }

    private String validDictDatas(List<DictData> dictDatas) {
        HashMap validMap = Maps.newHashMap();
        for (DictData data : dictDatas) {
            if (StringUtils.isEmpty((CharSequence)data.getName()) || StringUtils.isEmpty((CharSequence)data.getCode()) || data.getDataSort() == null) {
                return "\u4e0d\u53ef\u6709\u6570\u636e\u9879\u4e3a\u7a7a";
            }
            if (!Objects.isNull(validMap.get("name" + data.getName()))) {
                return "\u540d\u79f0\u4e0d\u53ef\u6709\u91cd\u590d";
            }
            validMap.put("name" + data.getName(), data.getName());
            if (Objects.isNull(validMap.get("code" + data.getCode()))) {
                validMap.put("code" + data.getCode(), data.getCode());
                continue;
            }
            return "\u7f16\u7801\u4e0d\u53ef\u6709\u91cd\u590d";
        }
        return "";
    }

    public DictData getDictByTypeCodeAndCode(String typeCode, String code) {
        return this.dictdataMapper.getDictByTypeCodeAndCode(typeCode, code);
    }
}

