/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class ClassPathIndexFile {
    private final File root;
    private final List<String> lines;
    private final Set<String> folders;

    private ClassPathIndexFile(File root, List<String> lines) {
        this.root = root;
        this.lines = lines;
        this.folders = this.lines.stream().map(this::getFolder).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private String getFolder(String name) {
        int lastSlash = name.lastIndexOf(47);
        return lastSlash != -1 ? name.substring(0, lastSlash) : null;
    }

    int size() {
        return this.lines.size();
    }

    boolean containsFolder(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.endsWith("/")) {
            return this.containsFolder(name.substring(0, name.length() - 1));
        }
        return this.folders.contains(name);
    }

    boolean containsEntry(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return this.lines.contains(name);
    }

    List<URL> getUrls() {
        return Collections.unmodifiableList(this.lines.stream().map(this::asUrl).collect(Collectors.toList()));
    }

    private URL asUrl(String line) {
        try {
            return new File(this.root, line).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static ClassPathIndexFile loadIfPossible(URL root, String location) throws IOException {
        return ClassPathIndexFile.loadIfPossible(ClassPathIndexFile.asFile(root), location);
    }

    private static ClassPathIndexFile loadIfPossible(File root, String location) throws IOException {
        return ClassPathIndexFile.loadIfPossible(root, new File(root, location));
    }

    private static ClassPathIndexFile loadIfPossible(File root, File indexFile) throws IOException {
        if (indexFile.exists() && indexFile.isFile()) {
            try (FileInputStream inputStream = new FileInputStream(indexFile);){
                ClassPathIndexFile classPathIndexFile = new ClassPathIndexFile(root, ClassPathIndexFile.loadLines(inputStream));
                return classPathIndexFile;
            }
        }
        return null;
    }

    private static List<String> loadLines(InputStream inputStream) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String line = reader.readLine();
        while (line != null) {
            if (!line.trim().isEmpty()) {
                lines.add(line);
            }
            line = reader.readLine();
        }
        return Collections.unmodifiableList(lines);
    }

    private static File asFile(URL url) {
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("URL does not reference a file");
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }
}

