/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.prefecture.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.rocogz.syy.business.prefecture.mapper.PrefectureMapper;
import com.rocogz.syy.business.prefecture.service.IPrefectureService;
import com.rocogz.syy.common.basicserialno.service.SerialNoService;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.tree.PrefectureTreeDto;
import com.rocogz.syy.infrastructure.entity.prefecture.Prefecture;
import com.rocogz.syy.util.BuildTreeUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrefectureServiceImpl
extends ServiceImpl<PrefectureMapper, Prefecture>
implements IPrefectureService {
    private static final String FIRST_LEVEL_PREFECTURE_PARENT_CODE = "0";
    private static final String CODE_SEQ = "PREFECTURE";
    @Autowired
    SerialNoService serialNoService;

    @Override
    public Response<List<Prefecture>> getChild(String prefectureCode) {
        List prefectures = ((PrefectureMapper)this.baseMapper).selectList((Wrapper)Wrappers.lambdaQuery().eq(Prefecture::getParentCode, (Object)prefectureCode));
        return Response.succeed((Object)prefectures);
    }

    @Override
    public Response<List<PrefectureTreeDto>> getPrefectureTree() {
        List prefectures = ((PrefectureMapper)this.baseMapper).selectList((Wrapper)Wrappers.emptyWrapper());
        List<PrefectureTreeDto> prefectureTreeDtoList = BuildTreeUtil.buildPrefectureTreeDtoList(prefectures, FIRST_LEVEL_PREFECTURE_PARENT_CODE);
        return Response.succeed(prefectureTreeDtoList);
    }

    @Override
    public boolean customSaveOrUpdate(Prefecture prefecture) {
        if (prefecture.getId() == null) {
            prefecture.setCode(this.serialNoService.generateCode(CODE_SEQ));
        }
        return this.saveOrUpdate(prefecture);
    }

    @Override
    public Response<List<Prefecture>> findPrefectureList() {
        List prefectures = ((PrefectureMapper)this.baseMapper).selectList((Wrapper)Wrappers.emptyWrapper());
        return Response.succeed((Object)prefectures);
    }

    @Override
    public Response<List<Prefecture>> findPrefectureByCode(Map<String, Object> params, List<String> prefectureCodeList) {
        List<Prefecture> prefectureByCode = ((PrefectureMapper)this.baseMapper).findPrefectureByCode(params, prefectureCodeList);
        return Response.succeed(prefectureByCode);
    }
}

