/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.system.role.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.rocogz.syy.business.system.menu.mapper.SystemRoleMenuMapper;
import com.rocogz.syy.business.system.role.mapper.PermissionMapper;
import com.rocogz.syy.business.system.role.mapper.SystemRoleMapper;
import com.rocogz.syy.business.system.role.service.ISystemRoleService;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.system.SetPermissionDto;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUserRole;
import com.rocogz.syy.infrastructure.entity.menu.Menu;
import com.rocogz.syy.infrastructure.entity.role.Role;
import com.rocogz.syy.infrastructure.enumerate.system.PermissionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemRoleServiceImpl
extends ServiceImpl<SystemRoleMapper, Role>
implements ISystemRoleService {
    @Autowired
    private PermissionMapper rolePermissionDao;
    @Autowired
    private SystemRoleMenuMapper menuDao;

    public List<Role> getRolesByUserId(Long userId) {
        return ((SystemRoleMapper)this.baseMapper).getRolesByUserId(userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public Response setRolesByUserId(Long userId, List<Long> roleIds) {
        if (userId == null || CollectionUtils.isEmpty(roleIds)) {
            return Response.failure((String)"id\u4e3anull\u6216\u6ca1\u6709\u9009\u62e9\u89d2\u8272");
        }
        ((SystemRoleMapper)this.baseMapper).deleteUserRolesByUserId(userId);
        List<AdminUserRole> userRoles = roleIds.stream().map(o -> new AdminUserRole(userId, o)).collect(Collectors.toList());
        ((SystemRoleMapper)this.baseMapper).batchInsertUserRole(userRoles);
        return Response.succeed();
    }

    public List<Role> searchScrollPage(IPage page, Map query) {
        return ((SystemRoleMapper)this.baseMapper).search(page, query);
    }

    @Transactional(rollbackFor={Exception.class})
    public Response saveOrUpdateLocal(Role role) {
        Role tempRole = ((SystemRoleMapper)this.baseMapper).getByNameExceptId(role.getId(), role.getName());
        if (tempRole != null) {
            return Response.failure((String)"\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        boolean i = role.getId() != null ? this.updateById(role) : this.save(role);
        if (i) {
            Response.failure((String)"\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return Response.succeed((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public Response deleteRole(Long id) {
        ((SystemRoleMapper)this.baseMapper).deleteById(id);
        ((SystemRoleMapper)this.baseMapper).deleteUserRolesByRoleId(id);
        this.rolePermissionDao.deleteByRoleId(id);
        return Response.succeed((String)"\u5220\u9664\u89d2\u8272\u6210\u529f\uff01");
    }

    public List<SetPermissionDto> findRolePermission(Long id) {
        ArrayList result = Lists.newArrayList();
        if (id == null) {
            return result;
        }
        List<SetPermissionDto> permissions = this.rolePermissionDao.findRolePermissionAsSetPermissionDto(id);
        List<Menu> menus = this.menuDao.findMenusByRoleId(id);
        List<SetPermissionDto> menuPermissions = this.buildMenuSetPermissionList(menus, 0);
        Map<Long, List<SetPermissionDto>> menuIdPermissionMap = permissions.stream().collect(Collectors.groupingBy(SetPermissionDto::getMenuId));
        for (SetPermissionDto menuPermission : menuPermissions) {
            for (SetPermissionDto permissionDto : menuPermission.getChildren()) {
                permissionDto.setChildren(menuIdPermissionMap.get(permissionDto.getId()));
            }
        }
        return menuPermissions;
    }

    @Transactional(rollbackFor={Exception.class})
    public Object setRolePermissions(Long id, List<SetPermissionDto> permissionDtos) {
        Role role = (Role)this.getById(id);
        if (role == null) {
            return Response.failure((String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u6b64\u89d2\u8272\u4fe1\u606f\uff01");
        }
        this.rolePermissionDao.deleteByRoleId(id);
        ((SystemRoleMapper)this.baseMapper).deleteRoleMenuByRoleId(id);
        if (CollectionUtils.isNotEmpty(permissionDtos)) {
            Map<PermissionType, List<SetPermissionDto>> permissionMap = permissionDtos.stream().collect(Collectors.groupingBy(SetPermissionDto::getType));
            List<SetPermissionDto> menuList = permissionMap.get(PermissionType.MENU);
            List<SetPermissionDto> permissionList = permissionMap.get(PermissionType.PERMISSION);
            if (id != null && CollectionUtils.isNotEmpty(permissionList)) {
                this.rolePermissionDao.batchInsert(id, permissionList);
            }
            if (id != null && CollectionUtils.isNotEmpty(menuList)) {
                ((SystemRoleMapper)this.baseMapper).batchInsertRoleMenu(id, menuList);
            }
        }
        return Response.succeed((String)"\u6743\u9650\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    private List<SetPermissionDto> buildMenuSetPermissionList(List<Menu> menus, Integer pid) {
        ArrayList result = Lists.newArrayList();
        for (Menu menu : menus) {
            SetPermissionDto dto = new SetPermissionDto();
            if (!menu.getPid().equals(pid)) continue;
            dto.setId(menu.getId());
            dto.setTitle(menu.getTitle());
            dto.setChecked(menu.getChecked());
            dto.setType(PermissionType.MENU);
            dto.setChildren(this.buildMenuSetPermissionList(menus, menu.getId()));
            result.add(dto);
        }
        return result;
    }

    public List<Role> findRoleList() {
        return ((SystemRoleMapper)this.baseMapper).findRoleList();
    }
}

