/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.rocogz.syy.GlobalExceptionHandler;
import com.rocogz.syy.common.response.Response;
import io.seata.common.util.CollectionUtils;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
        binder.registerCustomEditor(LocalDate.class, (PropertyEditor)new CustomLocalDateEditor());
        binder.registerCustomEditor(LocalDateTime.class, (PropertyEditor)new CustomLocalDateTimeEditor());
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
    }

    @ExceptionHandler(value={BindException.class})
    public Object validationException(BindException ex) {
        List errors = ex.getFieldErrors();
        String msg = this.getMessageFrom(errors);
        log.error(msg);
        return Response.failure((String)msg);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object methodArgumentNotValidException(MethodArgumentNotValidException ex) {
        List errors = ex.getBindingResult().getFieldErrors();
        String msg = this.getMessageFrom(errors);
        log.error(msg);
        return Response.failure((String)msg);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Object illegalArgumentException(IllegalArgumentException ex) {
        log.error(ExceptionUtil.stacktraceToString((Throwable)ex));
        return Response.failure((String)ex.getMessage());
    }

    @ExceptionHandler(value={ValidationException.class})
    public Object validationException(ValidationException ex) {
        log.error(ExceptionUtil.stacktraceToString((Throwable)ex));
        return Response.failure((String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public Object exception(Exception ex) {
        log.error(ExceptionUtil.stacktraceToString((Throwable)ex));
        return Response.failure((String)"\u4e1a\u52a1\u5f02\u5e38");
    }

    private String getMessageFrom(List<FieldError> errors) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(errors)) {
            errors.forEach(o -> sb.append(o.getDefaultMessage()).append(","));
        }
        sb.delete(sb.lastIndexOf(","), sb.length());
        return sb.toString();
    }
}

