/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.system.dict.controller;

import com.rocogz.syy.business.system.dict.service.impl.DictDataServiceImpl;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.entity.dict.DictData;
import com.rocogz.syy.infrastructure.enumerate.StatusEnum;
import com.rocogz.util.MapUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dict/data"})
public class DictDataController {
    @Autowired
    private DictDataServiceImpl dataService;

    @GetMapping
    public Response<List<DictData>> search(@RequestParam(required=false) String pCode, @RequestParam(required=false) String typeCode, @RequestParam(required=false) String status, @RequestParam(required=false) String code, @RequestParam(required=false) String keyword) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        MapUtils.putNotNull(params, (String)"pCode", (Object)pCode);
        MapUtils.putNotNull(params, (String)"typeCode", (Object)typeCode);
        MapUtils.putNotNull(params, (String)"status", (Object)status);
        MapUtils.putNotNull(params, (String)"keyword", (Object)keyword);
        MapUtils.putNotNull(params, (String)"code", (Object)code);
        return Response.succeed(this.dataService.search(params));
    }

    @GetMapping(value={"/{id}"})
    public Response<DictData> get(@PathVariable Long id) {
        return Response.succeed((Object)this.dataService.getById(id));
    }

    @PostMapping(value={"/status/{id}"})
    public Response switchStatus(@PathVariable Long id, @RequestParam StatusEnum status) {
        int i = this.dataService.updateStatusById(id, status);
        if (i > 0) {
            return Response.succeed();
        }
        return Response.failure();
    }

    @PostMapping(value={"/batchEdit"})
    public Response batchEdit(@RequestBody List<DictData> dictDatas) {
        if (dictDatas != null && dictDatas.size() > 0) {
            try {
                this.dataService.batchEdit(dictDatas);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Response.failure((String)e.getMessage());
            }
            return Response.succeed((String)"\u8bbe\u7f6e\u6210\u529f");
        }
        return Response.failure((String)"\u8bf7\u6700\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u5b57\u5178\u503c");
    }

    @GetMapping(value={"/get/{typeCode}"})
    public Response<List<DictData>> getDictDataByTypeCode(@PathVariable String typeCode) {
        return Response.succeed(this.dataService.getDictByTypeCode(typeCode));
    }

    @GetMapping(value={"/getDataByTypeCodeList"})
    Response<Map<String, List<DictData>>> getDataByTypeCodeList(@RequestParam(value="typeCodeList") List<String> typeCodeList) {
        return Response.succeed(this.dataService.getDataByTypeCodeList(typeCodeList));
    }
}

