/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.system.menu.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.rocogz.syy.business.system.menu.mapper.SystemRoleMenuMapper;
import com.rocogz.syy.business.system.menu.service.ISystemRoleMenuService;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.tree.MenuTreeDto;
import com.rocogz.syy.infrastructure.entity.menu.Menu;
import com.rocogz.syy.infrastructure.enumerate.StatusEnum;
import com.rocogz.syy.util.BuildTreeUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemRoleMenuServiceImpl
extends ServiceImpl<SystemRoleMenuMapper, Menu>
implements ISystemRoleMenuService {
    public List<Menu> searchScrollPage(IPage page, Map query) {
        return ((SystemRoleMenuMapper)this.baseMapper).search(page, query);
    }

    public List<MenuTreeDto> findMenuTree() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ne((Object)"id", (Object)0);
        queryWrapper.orderByAsc((Object)"seq");
        List menus = this.list((Wrapper)queryWrapper);
        return BuildTreeUtil.buildMenuTreeDtoList((List)menus, (Integer)0);
    }

    public boolean codeOrTitleIsExist(Integer id, String code, String title) {
        return ((SystemRoleMenuMapper)this.baseMapper).codeOrTitleIsExist(id, code, title) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public Object edit(Menu menu) {
        if (menu == null || StringUtils.isEmpty((CharSequence)menu.getTitle())) {
            return Response.failure((String)"\u83dc\u5355\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (menu.getPid() == null) {
            return Response.failure((String)"\u7236\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (menu.getPid() != 0) {
            Menu pMenu = (Menu)this.getById((Serializable)menu.getPid());
            if (pMenu == null) {
                return Response.failure((String)"\u7236\u83dc\u5355\u4e0d\u5b58\u5728");
            }
            if (StatusEnum.LOCK.equals((Object)pMenu.getStatus())) {
                return Response.failure((String)"\u7236\u83dc\u5355\u5df2\u505c\u7528\u4e0d\u53ef\u521b\u5efa\u5b50\u83dc\u5355");
            }
            if (pMenu.getLevel() + 1 > 2) {
                return Response.failure((String)"\u6700\u591a\u652f\u63012\u7ea7\u83dc\u5355");
            }
            menu.setLevel(Integer.valueOf(pMenu.getLevel() + 1));
        } else {
            menu.setLevel(Integer.valueOf(1));
        }
        if (menu.getId() == null) {
            this.save((Object)menu);
            ((SystemRoleMenuMapper)this.baseMapper).insertRoleMenu(menu.getId());
        } else {
            boolean isModifyParent;
            Integer maxSeq = ((SystemRoleMenuMapper)this.baseMapper).getMaxSeq(menu.getPid());
            Menu oldMenu = (Menu)this.getById((Serializable)menu.getId());
            boolean bl = isModifyParent = !oldMenu.getPid().equals(menu.getPid());
            if (!oldMenu.getSeq().equals(menu.getSeq()) || isModifyParent) {
                if (isModifyParent) {
                    List sonsList;
                    if (oldMenu.getLevel() == 1 && (sonsList = ((SystemRoleMenuMapper)this.baseMapper).findSonsMenuByParentId(oldMenu.getId())) != null && sonsList.size() > 0) {
                        return Response.failure((String)"\u5c1a\u6709\u5b50\u83dc\u5355\uff0c\u4e0d\u53ef\u66f4\u6539\u7236\u83dc\u5355");
                    }
                    ((SystemRoleMenuMapper)this.baseMapper).updateOldSeq(oldMenu.getSeq(), oldMenu.getPid());
                    menu.setSeq(Integer.valueOf(maxSeq + 1));
                } else {
                    if (menu.getSeq() > maxSeq) {
                        return Response.failure((String)"\u4f4d\u7f6e\u503c\u8d85\u8fc7\u6700\u5927\u503c");
                    }
                    if (oldMenu.getSeq() > menu.getSeq()) {
                        ((SystemRoleMenuMapper)this.baseMapper).updateNewLtSeq(oldMenu.getSeq(), menu.getPid(), menu.getSeq());
                    } else {
                        ((SystemRoleMenuMapper)this.baseMapper).updateNewGtSeq(oldMenu.getSeq(), menu.getPid(), menu.getSeq());
                    }
                }
            }
            ((SystemRoleMenuMapper)this.baseMapper).updateById((Object)menu);
        }
        return Response.succeed();
    }

    public List<Menu> findAllOpen() {
        return ((SystemRoleMenuMapper)this.baseMapper).findAllOpen();
    }
}

