/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.system.adminuser.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.rocogz.syy.business.system.adminuser.service.impl.SystemAdminUserServiceImpl;
import com.rocogz.syy.business.system.adminuser.service.impl.SystemUserRoleServiceImpl;
import com.rocogz.syy.business.system.permission.service.impl.SystemPermissionServiceImpl;
import com.rocogz.syy.business.system.role.service.impl.PermissionServiceImpl;
import com.rocogz.syy.business.system.role.service.impl.SystemRoleServiceImpl;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.basicserialno.service.SerialNoService;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUserRole;
import com.rocogz.syy.infrastructure.entity.role.RolePermission;
import com.rocogz.syy.infrastructure.enumerate.StatusEnum;
import com.rocogz.util.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system/users"})
public class SystemAdminUserController {
    @Autowired
    private SystemAdminUserServiceImpl userService;
    @Autowired
    private SystemRoleServiceImpl roleService;
    @Autowired
    private SystemUserRoleServiceImpl systemUserRoleService;
    @Autowired
    private SystemPermissionServiceImpl systemPermissionService;
    @Autowired
    private PermissionServiceImpl permissionService;
    @Autowired
    private SerialNoService serialNoService;

    @GetMapping(value={"/no"})
    public Response<String> seriaNo() {
        return Response.succeed((String)this.serialNoService.generateCode("TEST"));
    }

    @GetMapping
    public Object search(@RequestParam(required=false, defaultValue="") String username, @RequestParam(required=false, defaultValue="") String name, @RequestParam(required=false, defaultValue="") String roleId, @RequestParam(required=false) StatusEnum status, @RequestParam(defaultValue="20") int limit, @RequestParam(defaultValue="1") int page) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            params.put("username", StringUtils.wrap((String)username, (String)"%"));
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            params.put("name", StringUtils.wrap((String)name, (String)"%"));
        }
        MapUtils.putNotNull(params, (String)"roleId", (Object)roleId);
        MapUtils.putNotNull(params, (String)"status", (Object)status);
        Page pageQuery = new Page((long)page, (long)limit);
        List<AdminUser> list = this.userService.searchScrollPage((IPage)pageQuery, params);
        return new PageTable(list, pageQuery.getTotal(), 0, "success");
    }

    @PostMapping(value={"/findMenu"})
    public Object findMenuByAdminUserId(@RequestParam Long userId) {
        return this.userService.findMenuByAdminUserId(userId);
    }

    @PostMapping
    public Object create(@RequestBody AdminUser user) {
        return this.userService.create(user);
    }

    @PostMapping(value={"/edit"})
    public Object edit(@RequestBody AdminUser user) {
        return this.userService.edit(user);
    }

    @GetMapping(value={"/{id}"})
    public Object getById(@PathVariable Long id) {
        return Response.succeed((Object)this.userService.getById(id));
    }

    @GetMapping(value={"/{id}/password"})
    public Object resetPwd(@PathVariable Integer id) {
        return this.userService.resetPwd(id);
    }

    @GetMapping(value={"/role/{id}"})
    public Object getRolesById(@PathVariable Long id) {
        return Response.succeed(this.roleService.getRolesByUserId(id));
    }

    @PostMapping(value={"/role/{id}"})
    public Object setRolesById(@PathVariable Long id, @RequestParam(value="roleIds") long[] roleIds) {
        if (roleIds.length == 0) {
            return Response.failure((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u89d2\u8272");
        }
        ArrayList r = Lists.newArrayList();
        for (int i = 0; i < roleIds.length; ++i) {
            r.add(roleIds[i]);
        }
        return this.roleService.setRolesByUserId(id, r);
    }

    @PostMapping(value={"/status/{id}"})
    public Object switchStatus(@PathVariable Integer id, @RequestParam StatusEnum status) {
        AdminUser user = new AdminUser(id);
        user.setStatus(status);
        if (this.userService.updateById(user)) {
            return Response.succeed();
        }
        return Response.failure();
    }

    @GetMapping(value={"/delete/{id}"})
    public Object deleteById(@PathVariable Long id) {
        this.userService.removeById(id);
        return Response.succeed();
    }

    @PostMapping(value={"/password/modify"})
    public Object updatePwd(@RequestParam(value="oldPwd") String oldPwd, @RequestParam(value="newPwd") String newPwd, @RequestParam(value="confirmPwd") String confirmPwd, Integer userId) {
        if (StringUtils.isBlank((CharSequence)oldPwd)) {
            return Response.failure((String)"\u539f\u5bc6\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)newPwd)) {
            return Response.failure((String)"\u65b0\u5bc6\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)confirmPwd)) {
            return Response.failure((String)"\u786e\u8ba4\u5bc6\u7801\u4e3a\u7a7a\uff01");
        }
        if (!newPwd.equals(confirmPwd)) {
            return Response.failure((String)"\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4\uff01");
        }
        return this.userService.modifyPwd(userId, oldPwd, newPwd);
    }

    @RequestMapping(value={"/batch/open"})
    public Object batchOpen(@RequestBody List<Long> idList) {
        if (idList.size() == 0) {
            return Response.failure((String)"\u8bf7\u9009\u62e9\u7ba1\u7406\u5458");
        }
        this.userService.batchOpen(idList);
        return Response.succeed();
    }

    @RequestMapping(value={"/batch/lock"})
    public Object batchLock(@RequestBody List<Long> idList) {
        if (idList.size() == 0) {
            return Response.failure((String)"\u8bf7\u9009\u62e9\u7ba1\u7406\u5458");
        }
        this.userService.batchLock(idList);
        return Response.succeed();
    }

    @RequestMapping(value={"/batch/resetpwd"})
    public Object resetPwd(@RequestBody List<Integer> idList) {
        if (idList.size() == 0) {
            return Response.failure((String)"\u8bf7\u9009\u62e9\u7ba1\u7406\u5458");
        }
        for (int i = 0; i < idList.size(); ++i) {
            this.userService.resetPwd(idList.get(i));
        }
        return Response.succeed();
    }

    @PostMapping(value={"/getAllInfoById"})
    public AdminUser getAllInfoById(Long id) {
        if (id != null) {
            return this.userService.getAllInfoById(id);
        }
        return null;
    }

    @PostMapping(value={"/getAllInfoByUsername"})
    public AdminUser getAllInfoByUsername(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            AdminUser user = this.userService.getAllInfoByUsername(username);
            List userRoles = this.systemUserRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)user.getId())).select(new String[]{"user_id", "role_id"}));
            if (CollectionUtils.isNotEmpty((Collection)userRoles)) {
                List roles = this.roleService.listByIds(userRoles.stream().map(AdminUserRole::getRoleId).collect(Collectors.toList()));
                List rolePermissions = this.permissionService.list((Wrapper)new QueryWrapper().select(new String[]{"role_id", "permission_id"}).in((Object)"role_id", (Collection)roles.stream().map(IdEntity::getId).collect(Collectors.toList())));
                List permissions = this.systemPermissionService.listByIds(rolePermissions.stream().map(RolePermission::getPermissionId).collect(Collectors.toList()));
                roles.forEach(role -> role.setPermission(permissions.stream().filter(e -> rolePermissions.stream().map(RolePermission::getPermissionId).collect(Collectors.toList()).contains(e.getId())).collect(Collectors.toList())));
                user.setRoles(roles);
            }
            return user;
        }
        return null;
    }

    @PostMapping(value={"/active"})
    public Response active(@RequestParam(value="id") Integer id, @RequestParam(value="password") String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return Response.failure((String)"\u5fc5\u8f93\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.userService.activeUser(id, password);
    }
}

