/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.business.system.role.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.rocogz.syy.business.system.role.service.impl.SystemRoleServiceImpl;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.system.SetPermissionDto;
import com.rocogz.syy.infrastructure.entity.role.Role;
import com.rocogz.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system/role"})
public class SystemRoleController {
    @Autowired
    private SystemRoleServiceImpl roleService;

    @GetMapping
    public Object search(@RequestParam(required=false) String keyword, @RequestParam(defaultValue="20") int limit, @RequestParam(defaultValue="1") int page) {
        HashMap params = new HashMap();
        MapUtils.putNotNull(params, (String)"keyword", (Object)keyword);
        Page pageQuery = new Page((long)page, (long)limit);
        List<Role> list = this.roleService.searchScrollPage((IPage)pageQuery, params);
        return new PageTable(list, pageQuery.getTotal(), 0, "");
    }

    @PostMapping
    public Object saveOrUpdate(@RequestBody Role role) {
        return this.roleService.saveOrUpdateLocal(role);
    }

    @GetMapping(value={"/{id}"})
    public Object getById(@PathVariable Long id) {
        return Response.succeed((Object)this.roleService.getById(id));
    }

    @GetMapping(value={"/delete/{id}"})
    public Object delete(@PathVariable Long id) {
        return this.roleService.deleteRole(id);
    }

    @GetMapping(value={"/permission/{id}"})
    public Object findRolePermission(@PathVariable(value="id") Long id) {
        return Response.succeed(this.roleService.findRolePermission(id));
    }

    @PostMapping(value={"/permission/{id}"})
    public Object setRolePermissions(@PathVariable Long id, @RequestBody List<SetPermissionDto> permissionDtos) {
        if (CollectionUtils.isEmpty(permissionDtos)) {
            return Response.failure((String)"\u6743\u9650\u4e3a\u7a7a\uff01");
        }
        return this.roleService.setRolePermissions(id, permissionDtos);
    }

    @GetMapping(value={"/role/{id}"})
    public Object getRolesByUserId(@PathVariable Long id) {
        return Response.succeed(this.roleService.getRolesByUserId(id));
    }

    @PostMapping(value={"/role/{id}"})
    public Object setRolesByUserId(@PathVariable Long id, @RequestParam(value="roles") long[] roleIds) {
        if (roleIds.length == 0) {
            return Response.failure((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u89d2\u8272");
        }
        ArrayList r = Lists.newArrayList();
        for (int i = 0; i < roleIds.length; ++i) {
            r.add(roleIds[i]);
        }
        return Response.succeed((Object)this.roleService.setRolesByUserId(id, r));
    }

    @GetMapping(value={"/findRoleList"})
    public Object findRoleList() {
        return Response.succeed(this.roleService.findRoleList());
    }
}

