/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.infrastructure.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.sms.SmsParamDto;
import com.rocogz.syy.infrastructure.dto.system.SetPermissionDto;
import com.rocogz.syy.infrastructure.dto.tree.MenuTreeDto;
import com.rocogz.syy.infrastructure.dto.tree.PrefectureTreeDto;
import com.rocogz.syy.infrastructure.dto.weixin.WeixinSubscribeMessageDto;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import com.rocogz.syy.infrastructure.entity.apiInfomation.ApiInformation;
import com.rocogz.syy.infrastructure.entity.area.entity.ProvCityArea;
import com.rocogz.syy.infrastructure.entity.dict.DictData;
import com.rocogz.syy.infrastructure.entity.dict.DictLicensePrefix;
import com.rocogz.syy.infrastructure.entity.dict.DictType;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatform;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatformIpAddr;
import com.rocogz.syy.infrastructure.entity.menu.Menu;
import com.rocogz.syy.infrastructure.entity.prefecture.Prefecture;
import com.rocogz.syy.infrastructure.entity.prefecture.PrefectureArea;
import com.rocogz.syy.infrastructure.entity.role.Role;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public interface IInfrastructureClientService {
    @PostMapping(value={"/api/basic/sms/send"})
    public Response<String> sendShortMsg(@RequestBody SmsParamDto var1);

    @GetMapping(value={"/api/basic/prov-city-area/getChildrenByPcode"})
    public Response<List<ProvCityArea>> getProvCityAreaListByPcode(@RequestParam(value="pcode") String var1);

    @GetMapping(value={"/api/basic/prov-city-area/getChildrenByPcodeWithLike"})
    public Response<List<ProvCityArea>> getChildrenByPcodeWithLike(@RequestParam(value="pcode") String var1);

    @GetMapping(value={"/api/dict/data"})
    public Response<List<DictData>> searchDictData(@RequestParam(value="pCode", required=false) String var1, @RequestParam(value="typeCode", required=false) String var2, @RequestParam(value="status", required=false) String var3, @RequestParam(value="code", required=false) String var4, @RequestParam(value="keyword", required=false) String var5);

    @GetMapping(value={"/api/dict/data/{id}"})
    public Response<DictData> getDictData(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/dict/data/status/{id}"})
    public Response switchDictDataStatus(@PathVariable(value="id") Long var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/dict/data/batchEdit"})
    public Response batchEditDictData(@RequestBody List<DictData> var1);

    @GetMapping(value={"/api/dict/data/get/{typeCode}"})
    public Response<List<DictData>> getDictDataByTypeCode(@PathVariable(value="typeCode") String var1);

    @GetMapping(value={"/api/dict/data/getDataByTypeCodeList"})
    public Response<Map<String, List<DictData>>> getDictDataByTypeCodeList(@RequestParam(value="typeCodeList") List<String> var1);

    @GetMapping(value={"/api/dict/data/getDictDataByTypeCodeAndCode"})
    public Response<DictData> getDictDataByTypeCodeAndCode(@RequestParam(value="typeCode") String var1, @RequestParam(value="code") String var2);

    @GetMapping(value={"/api/dict/type"})
    public PageTable<DictType> searchDictType(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/dict/type/{id}"})
    public Response<DictType> getDictType(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/dict/type/status/{id}"})
    public Response switchDictTypeStatus(@PathVariable(value="id") Long var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/dict/type"})
    public Response saveOrUpdateDictType(DictType var1);

    @GetMapping(value={"/api/basic/prefectureArea/listByPrefectureCode"})
    public Response<List<PrefectureArea>> listPrefectureAreaByPrefectureCode(@RequestParam(value="prefectureCode") String var1);

    @PostMapping(value={"/api/basic/prefectureArea/queryByEntity"})
    public Response<PrefectureArea> queryPrefectureAreaByEntity(@RequestBody PrefectureArea var1);

    @PostMapping(value={"/api/basic/prefectureArea"})
    public Response addPrefectureArea(@RequestBody PrefectureArea var1);

    @PostMapping(value={"/api/basic/prefectureArea/saveBatch"})
    public Response saveBatchPrefectureArea(@RequestBody List<PrefectureArea> var1);

    @DeleteMapping(value={"/api/basic/prefectureArea"})
    public Response removePrefectureArea(@RequestParam(value="id") Integer var1);

    @GetMapping(value={"/api/basic/prefecture/getChild"})
    public Response<List<Prefecture>> getPrefectureChild(@RequestParam(value="prefectureCode") String var1);

    @GetMapping(value={"/api/basic/prefecture/pageQuery"})
    public PageTable<Prefecture> pageQueryPrefecture(@RequestParam(value="code", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="status", required=false) String var3, @RequestParam(value="page", defaultValue="1") Integer var4, @RequestParam(value="limit", defaultValue="20") Integer var5);

    @GetMapping(value={"/api/basic/prefecture/getTree"})
    public Response<List<PrefectureTreeDto>> getPrefectureTree();

    @GetMapping(value={"/api/basic/prefecture/{id}"})
    public Response<Prefecture> getPrefectureById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/basic/prefecture/getByCode"})
    public Response<Prefecture> getPrefectureByCode(@RequestParam(value="code") String var1);

    @PostMapping(value={"/api/basic/prefecture"})
    public Response saveOrUpdatePrefecture(@RequestBody Prefecture var1);

    @GetMapping(value={"/api/basic/prefecture/findPrefectureList"})
    public Response<List<Prefecture>> findPrefectureList(@RequestParam(value="status", required=false) String var1, @RequestParam(value="openServiceStatus", required=false) String var2);

    @GetMapping(value={"/api/basic/prefecture/findPrefectureByCode"})
    public Response<List<Prefecture>> findPrefectureListByCode(@RequestParam(value="code", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="prefectureCodeList") List<String> var3);

    @PostMapping(value={"/api/basic/prefecture/getOneAvailablePrefectureByArea"})
    public Response<Prefecture> getOneAvailablePrefectureByArea(@RequestBody PrefectureArea var1);

    @PostMapping(value={"/api/basic/prefecture/listAvailablePrefectureByArea"})
    public Response<List<Prefecture>> listAvailablePrefectureByArea(@RequestBody PrefectureArea var1);

    @GetMapping(value={"/api/basic/dockingPlatform"})
    public PageTable<DockingPlatform> findDockingPlatformList(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="limit", defaultValue="20") int var3, @RequestParam(value="page", defaultValue="1") int var4);

    @PostMapping(value={"/api/basic/dockingPlatform/changeDockingPlatformstatus"})
    public Response changeDockingPlatformstatus(@RequestBody DockingPlatform var1);

    @GetMapping(value={"/api/basic/dockingPlatform/{id}"})
    public Response<DockingPlatform> getDockingPlatformById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/basic/dockingPlatform/getDockingPlatformByCode"})
    public Response<DockingPlatform> getDockingPlatformByCode(@RequestParam(value="code") String var1, @RequestParam(value="status", required=false) String var2);

    @PostMapping(value={"/api/basic/dockingPlatform/saveOrUpdateDockingPlatform"})
    public Response saveOrUpdateDockingPlatform(@RequestBody DockingPlatform var1);

    @GetMapping(value={"/api/basic/dockingPlatform/findDockingPlatformListNoKeyAndIv"})
    public Response<List<DockingPlatform>> findDockingPlatformListNoKeyAndIv(@RequestParam(value="provideCoupon", required=false) String var1, @RequestParam(value="status", required=false) String var2);

    @GetMapping(value={"/api/basic/dockingPlatform/getDockingPlatformByCodeNoKeyAndIv"})
    public Response<DockingPlatform> getDockingPlatformByCodeNoKeyAndIv(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/basic/dockingPlatform/getDockingPlatformListByCodeListNoKeyAndIv"})
    public Response<List<DockingPlatform>> getDockingPlatformListByCodeListNoKeyAndIv(@RequestParam(value="codeList") List<String> var1);

    @GetMapping(value={"/api/basic/apiInfomation/queryApi"})
    public PageTable<ApiInformation> queryApi(@RequestParam(value="platformCode", required=false) String var1, @RequestParam(value="serviceName", required=false) String var2, @RequestParam(value="name", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @GetMapping(value={"/api/basic/apiInfomation/findApiInformationList"})
    public PageTable<ApiInformation> findApiInformationList(@RequestParam(value="serviceName", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="limit", defaultValue="20") int var3, @RequestParam(value="page", defaultValue="1") int var4);

    @GetMapping(value={"/api/basic/apiInfomation/queryApiList"})
    public PageTable<ApiInformation> queryApiList(@RequestParam(value="limit", defaultValue="20") int var1, @RequestParam(value="page", defaultValue="1") int var2);

    @GetMapping(value={"/api/basic/apiInfomation/deleteApiByPlatformCode"})
    public Response deleteApiByPlatformCode(@RequestParam(value="platformCode") String var1, @RequestParam(value="apiId") Integer var2);

    @GetMapping(value={"/api/basic/apiInfomation/getApiListByPlatformCode"})
    public Response<List<ApiInformation>> getApiListByPlatformCode(@RequestParam(value="platformCode") String var1);

    @GetMapping(value={"/api/basic/apiInfomation/getApiListByPlatformCodeAndStatus"})
    public Response<List<ApiInformation>> getApiListByPlatformCodeAndStatus(@RequestParam(value="platformCode") String var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/basic/apiInfomation/changePlatformApiStatusById/{apiId}"})
    public Response changePlatformApiStatusById(@PathVariable(value="apiId") Integer var1, @RequestParam(value="status") String var2, @RequestParam(value="platformCode") String var3, @RequestParam(value="updateUser") String var4);

    @PostMapping(value={"/api/basic/apiInfomation/addApiListByPlatformCode"})
    public Response addApiListByPlatformCode(@RequestParam(value="apiIdList") List<Integer> var1, @RequestParam(value="platformCode") String var2, @RequestParam(value="updateUser") String var3);

    @RequestMapping(value={"/api/basic/dict/dictLicensePrefix"})
    public Response<DictLicensePrefix> getLicensePrefixByProvCityNameLike(@RequestParam(value="provName") String var1, @RequestParam(value="cityName") String var2);

    @GetMapping(value={"/api/system/users"})
    public PageTable<AdminUser> findAdminUserList(@RequestParam(value="username", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="roleId", required=false) String var3, @RequestParam(value="status", required=false) String var4, @RequestParam(value="limit", defaultValue="20") int var5, @RequestParam(value="page", defaultValue="1") int var6);

    @PostMapping(value={"/api/system/users/findMenu"})
    public List<Menu> findMenuByAdminUserId(@RequestParam(value="userId") Integer var1);

    @PostMapping(value={"/api/system/users"})
    public Response createAdminUser(AdminUser var1);

    @PostMapping(value={"/api/system/users/edit"})
    public Response editAdminUser(AdminUser var1);

    @GetMapping(value={"/api/system/users/{id}"})
    public Response<AdminUser> getAdminUserById(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/users/{id}/password"})
    public Response resetAdminUserPwd(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/users/role/{id}"})
    public Response<List<Role>> getAdminUserRolesById(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/system/users/role/{id}"})
    public Response setAdminUserRolesById(@PathVariable(value="id") Long var1, @RequestParam(value="roleIds") long[] var2);

    @PostMapping(value={"/api/system/users/status/{id}"})
    public Response switchAdminUserStatus(@PathVariable(value="id") Long var1, @RequestParam(value="status") String var2);

    @GetMapping(value={"/api/system/users/delete/{id}"})
    public Response deleteAdminUserById(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/system/users/password/modify"})
    public Response updateAdminUserPwd(@RequestParam(value="oldPwd") String var1, @RequestParam(value="newPwd") String var2, @RequestParam(value="confirmPwd") String var3, @RequestParam(value="userId") Integer var4);

    @RequestMapping(value={"/api/system/users/batch/open"})
    public Response batchOpenAdminUser(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/system/users/batch/lock"})
    public Response batchLockAdminUser(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/system/users/batch/resetpwd"})
    public Response resetAdminUserPwd(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/system/users/getAllInfoById"})
    public AdminUser getAdminUserAllInfoById(@RequestParam(value="id") Integer var1);

    @PostMapping(value={"/api/system/users/getAllInfoByUsername"})
    public AdminUser getAdminUserAllInfoByUsername(@RequestParam(value="username") String var1);

    @PostMapping(value={"/api/system/users/active"})
    public Response activeAdminUser(@RequestParam(value="id") Long var1, @RequestParam(value="password") String var2);

    @PostMapping(value={"/api/system/users/names"})
    public Response<List<AdminUser>> queryAccountListByUsenames(@RequestBody List<String> var1);

    @GetMapping(value={"/api/system/users/getUserListByRoleId/{roleId}"})
    public Response<List<AdminUser>> getUserListByRoleId(@PathVariable(value="roleId") Integer var1);

    @GetMapping(value={"/api/system/role"})
    public PageTable<Role> pageFindRoleList(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @PostMapping(value={"/api/system/role"})
    public Response saveOrUpdateRole(Role var1);

    @GetMapping(value={"/api/system/role/{id}"})
    public Response<Role> getRoleById(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/role/delete/{id}"})
    public Response deleteRole(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/role/permission/{id}"})
    public Response<List<SetPermissionDto>> findRolePermission(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/system/role/permission/{id}"})
    public Response setRolePermissions(@PathVariable(value="id") Long var1, List<SetPermissionDto> var2);

    @GetMapping(value={"/api/system/role/role/{id}"})
    public Response<List<Role>> getRolesByUserId(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/system/role/role/{id}"})
    public Response setRolesByUserId(@PathVariable(value="id") Long var1, @RequestParam(value="roles") long[] var2);

    @GetMapping(value={"/api/system/role/findRoleList"})
    public Response<List<Role>> findRoleList();

    @GetMapping(value={"/api/menu"})
    public PageTable<Menu> findMenuList(@RequestParam(value="pid") Long var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/menu/findMenuTree"})
    public Response<List<MenuTreeDto>> findMenuTree();

    @GetMapping(value={"/api/menu/getById/{id}"})
    public Response<Menu> getMenuById(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/menu"})
    public Response editMenu(Menu var1);

    @GetMapping(value={"/api/menu/findAllOpen"})
    public Response<List<Menu>> findAllOpenMenu();

    @PostMapping(value={"/api/menu/status/{id}"})
    public Response switchStatus(@PathVariable(value="id") Integer var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/weixin/message/send"})
    public Response sendSubcribeMsg(@RequestBody WeixinSubscribeMessageDto var1);

    @GetMapping(value={"/api/basic/dockingPlatformIpAddr/findDockingPlatformIpAddrList"})
    public Response<List<DockingPlatformIpAddr>> findDockingPlatformIpAddrList(@RequestParam(value="platformCode") String var1);

    @PostMapping(value={"/api/basic/dockingPlatformIpAddr/updateDockingPlatformIpAddrList"})
    public Response updateDockingPlatformIpAddrList(@RequestParam(value="platformCode") String var1, @RequestBody List<DockingPlatformIpAddr> var2);
}

